/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.util;

import com.google.common.base.Preconditions;
import com.pau101.fairylights.util.Mth;
import java.util.Random;
import net.minecraft.util.math.MathHelper;

public final class RandomArray {
    private final float[] values;

    public RandomArray(long seed, int length) {
        this(seed, length, -1.0f, 1.0f);
    }

    public RandomArray(long seed, int length, float min, float max) {
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"length must be greater than zero");
        this.values = new float[length];
        Random rng = new Random(seed);
        float range = max - min;
        for (int i = 0; i < length; ++i) {
            this.values[i] = rng.nextFloat() * range + min;
        }
    }

    public float get(int index) {
        return this.values[Mth.mod(index, this.values.length)];
    }

    public float get(float t) {
        int t0 = MathHelper.func_76141_d((float)Mth.mod(t, (float)this.values.length));
        int t1 = Mth.mod(t0 + 1, this.values.length);
        return this.values[t0] * (1.0f - t % 1.0f) + this.values[t1] * (t % 1.0f);
    }
}

