/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.whatloomsahead.tileentity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.BannerTextures;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.util.ResourceLocation;

public class BannerPatternUtils {
    protected static List<BannerPattern> mainPatternList = new ArrayList<BannerPattern>();
    protected static List<BannerPattern> extraPatternList = new ArrayList<BannerPattern>();
    protected static List<BannerPattern> excludedVanillaPatterns = new ArrayList<BannerPattern>();

    public static void addPatternToMainList(BannerPattern pattern) {
        mainPatternList.add(pattern);
    }

    public static void addPatternToExtraList(BannerPattern pattern) {
        extraPatternList.add(pattern);
        BannerPatternUtils.addPatternExclusion(pattern);
    }

    public static List<BannerPattern> getMainPatternList() {
        return mainPatternList;
    }

    public static List<BannerPattern> getExtraPatternList() {
        return extraPatternList;
    }

    public static void addPatternExclusion(BannerPattern pattern) {
        excludedVanillaPatterns.add(pattern);
    }

    public static void addPatternExclusions(BannerPattern[] patterns) {
        excludedVanillaPatterns.addAll(Arrays.asList(patterns));
    }

    public static void addVanillaPatterns() {
        BannerPattern[] excludedPatterns = new BannerPattern[]{BannerPattern.CREEPER, BannerPattern.SKULL, BannerPattern.FLOWER, BannerPattern.MOJANG};
        BannerPatternUtils.addPatternExclusions(excludedPatterns);
        for (int i = 0; i < BannerPattern.values().length && i < BannerPattern.values().length; ++i) {
            boolean inMainList;
            BannerPattern pattern = BannerPattern.values()[i];
            boolean bl = inMainList = !excludedVanillaPatterns.contains(pattern);
            if (inMainList) {
                BannerPatternUtils.addPatternToMainList(pattern);
                continue;
            }
            BannerPatternUtils.addPatternToExtraList(pattern);
        }
    }

    public static ResourceLocation getPatternResourceLocation(BannerPattern pattern) {
        EnumDyeColor grayColor = EnumDyeColor.GRAY;
        EnumDyeColor whiteColor = EnumDyeColor.WHITE;
        ArrayList colors = Lists.newArrayList((Object[])new EnumDyeColor[]{grayColor, whiteColor});
        String s = "b" + grayColor.func_176765_a();
        String s1 = pattern.func_190993_b() + whiteColor.func_176765_a();
        ResourceLocation texture = BannerTextures.field_178466_c.func_187478_a(s + s1, (List)Lists.newArrayList((Object[])new BannerPattern[]{BannerPattern.BASE, pattern}), (List)colors);
        return texture;
    }

    public static void init() {
        BannerPatternUtils.addVanillaPatterns();
    }
}

