/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.whatloomsahead.inventory.container;

import java.util.Arrays;
import java.util.List;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemBanner;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thefloydman.whatloomsahead.item.ItemBannerPattern;
import thefloydman.whatloomsahead.tileentity.BannerPatternUtils;
import thefloydman.whatloomsahead.util.WhatLoomsAheadSoundEvents;

public class ContainerLoom
extends Container {
    private int currentExtraPattern = 0;
    private int currentMainPattern = 0;
    private Runnable runnable = () -> {};
    private final Slot bannerSlot;
    private final Slot dyeSlot;
    private final Slot patternSlot;
    private final Slot outputSlot;
    private final IInventory loomInput = new InventoryBasic("loom_input", false, 3){

        public void func_70296_d() {
            super.func_70296_d();
            ContainerLoom.this.func_75130_a((IInventory)this);
            ContainerLoom.this.runnable.run();
        }
    };
    private final IInventory loomOutput = new InventoryBasic("loom_output", false, 1){

        public void func_70296_d() {
            super.func_70296_d();
            ContainerLoom.this.runnable.run();
        }
    };
    public static List<EnumDyeColor> remappedColors = Arrays.asList(EnumDyeColor.BLACK, EnumDyeColor.RED, EnumDyeColor.GREEN, EnumDyeColor.BROWN, EnumDyeColor.BLUE, EnumDyeColor.PURPLE, EnumDyeColor.CYAN, EnumDyeColor.SILVER, EnumDyeColor.GRAY, EnumDyeColor.PINK, EnumDyeColor.LIME, EnumDyeColor.YELLOW, EnumDyeColor.LIGHT_BLUE, EnumDyeColor.MAGENTA, EnumDyeColor.ORANGE, EnumDyeColor.WHITE);

    public ContainerLoom(int p_i50073_1_, InventoryPlayer playerContainer) {
        this(p_i50073_1_, playerContainer, BlockPos.field_177992_a);
    }

    public ContainerLoom(int p_i50074_1_, InventoryPlayer playerContainer, BlockPos posIn) {
        this.bannerSlot = this.func_75146_a(new Slot(this.loomInput, 0, 13, 26){

            public boolean func_75214_a(ItemStack stack) {
                return stack.func_77973_b() instanceof ItemBanner;
            }
        });
        this.dyeSlot = this.func_75146_a(new Slot(this.loomInput, 1, 33, 26){

            public boolean func_75214_a(ItemStack stack) {
                return stack.func_77973_b() instanceof ItemDye;
            }
        });
        this.patternSlot = this.func_75146_a(new Slot(this.loomInput, 2, 23, 45){

            public boolean func_75214_a(ItemStack stack) {
                return stack.func_77973_b() instanceof ItemBannerPattern;
            }
        });
        this.outputSlot = this.func_75146_a(new Slot(this.loomOutput, 0, 143, 58){

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }

            public ItemStack func_190901_a(EntityPlayer thePlayer, ItemStack stack) {
                ContainerLoom.this.bannerSlot.func_75209_a(1);
                ContainerLoom.this.dyeSlot.func_75209_a(1);
                if (!ContainerLoom.this.bannerSlot.func_75216_d() || !ContainerLoom.this.dyeSlot.func_75216_d()) {
                    ContainerLoom.this.currentMainPattern = 0;
                }
                World world = thePlayer.func_130014_f_();
                if (world.field_72995_K) {
                    ((EntityPlayerSP)thePlayer).func_184185_a(WhatLoomsAheadSoundEvents.UI_LOOM_TAKE_RESULT, 0.25f, 1.0f);
                } else {
                    thePlayer.func_184185_a(WhatLoomsAheadSoundEvents.UI_LOOM_TAKE_RESULT, 0.25f, 1.0f);
                }
                return super.func_190901_a(thePlayer, stack);
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerContainer, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)playerContainer, k, 8 + k * 18, 142));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getCurrentMainPattern() {
        return this.currentMainPattern;
    }

    @SideOnly(value=Side.CLIENT)
    public int getCurrentExtraPattern() {
        return this.currentExtraPattern;
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return true;
    }

    public boolean func_75140_a(EntityPlayer playerIn, int id) {
        if (id > 0 && id <= BannerPatternUtils.getMainPatternList().size()) {
            this.currentMainPattern = id;
            this.func_217031_j(id);
            return true;
        }
        return false;
    }

    public void func_75130_a(IInventory inventoryIn) {
        ItemStack bannerStack = this.bannerSlot.func_75211_c();
        ItemStack dyeStack = this.dyeSlot.func_75211_c();
        ItemStack patternStack = this.patternSlot.func_75211_c();
        ItemStack outputStack = this.outputSlot.func_75211_c();
        if (outputStack.func_190926_b() || !bannerStack.func_190926_b() && !dyeStack.func_190926_b() && this.currentMainPattern > 0 && (this.currentMainPattern < BannerPatternUtils.getMainPatternList().size() || !patternStack.func_190926_b())) {
            if (!patternStack.func_190926_b() && patternStack.func_77973_b() instanceof ItemBannerPattern) {
                boolean flag;
                NBTTagCompound compoundnbt = bannerStack.func_190925_c("BlockEntityTag");
                boolean bl = flag = compoundnbt.func_150297_b("Patterns", 9) && !bannerStack.func_190926_b() && compoundnbt.func_150295_c("Patterns", 10).func_74745_c() >= 6;
                if (flag) {
                    this.currentExtraPattern = 0;
                } else if (((ItemBannerPattern)patternStack.func_77973_b()).getBannerPattern() != null) {
                    this.currentExtraPattern = this.indexOfIdInPatternList(BannerPatternUtils.getExtraPatternList(), ((ItemBannerPattern)patternStack.func_77973_b()).getBannerPattern().func_190993_b());
                    System.out.println(BannerPatternUtils.getExtraPatternList());
                } else {
                    this.currentExtraPattern = 100;
                }
            }
        } else {
            this.outputSlot.func_75215_d(ItemStack.field_190927_a);
            this.currentMainPattern = 0;
        }
        this.func_217031_j(this.currentMainPattern);
        this.func_217031_j(-(this.currentExtraPattern + 1));
        this.func_75142_b();
    }

    @SideOnly(value=Side.CLIENT)
    public void setRunnable(Runnable runnableIn) {
        this.runnable = runnableIn;
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack itemStackOut = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemStackIn = slot.func_75211_c();
            itemStackOut = itemStackIn.func_77946_l();
            if (index == this.outputSlot.field_75222_d) {
                if (!this.func_75135_a(itemStackIn, 4, 40, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemStackIn, itemStackOut);
            } else if (index != this.dyeSlot.field_75222_d && index != this.bannerSlot.field_75222_d && index != this.patternSlot.field_75222_d ? (itemStackIn.func_77973_b() instanceof ItemBanner ? !this.func_75135_a(itemStackIn, this.bannerSlot.field_75222_d, this.bannerSlot.field_75222_d + 1, false) : (itemStackIn.func_77973_b() instanceof ItemDye ? !this.func_75135_a(itemStackIn, this.dyeSlot.field_75222_d, this.dyeSlot.field_75222_d + 1, false) : (itemStackIn.func_77973_b() instanceof ItemBannerPattern ? !this.func_75135_a(itemStackIn, this.patternSlot.field_75222_d, this.patternSlot.field_75222_d + 1, false) : (index >= 4 && index < 31 ? !this.func_75135_a(itemStackIn, 31, 40, false) : index >= 31 && index < 40 && !this.func_75135_a(itemStackIn, 4, 31, false))))) : !this.func_75135_a(itemStackIn, 4, 40, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemStackIn.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemStackIn.func_190916_E() == itemStackOut.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemStackIn);
        }
        return itemStackOut;
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        this.func_193327_a(playerIn, playerIn.field_70170_p, this.loomInput);
    }

    private void func_217031_j(int index) {
        if (index > 0) {
            ItemStack bannerStack = this.bannerSlot.func_75211_c();
            ItemStack dyeStack = this.dyeSlot.func_75211_c();
            ItemStack outputStack = ItemStack.field_190927_a;
            if (!bannerStack.func_190926_b() && !dyeStack.func_190926_b()) {
                NBTTagList list;
                outputStack = bannerStack.func_77946_l();
                outputStack.func_190920_e(1);
                if (index >= BannerPatternUtils.getMainPatternList().size()) {
                    return;
                }
                String patternName = BannerPatternUtils.getMainPatternList().get(index).func_190993_b();
                EnumDyeColor dyecolor = EnumDyeColor.func_176766_a((int)dyeStack.func_77960_j());
                NBTTagCompound baseCompound = outputStack.func_190925_c("BlockEntityTag");
                if (baseCompound.func_150297_b("Patterns", 9)) {
                    list = baseCompound.func_150295_c("Patterns", 10);
                } else {
                    list = new NBTTagList();
                    baseCompound.func_74782_a("Patterns", (NBTBase)list);
                }
                NBTTagCompound subCompound = new NBTTagCompound();
                subCompound.func_74778_a("Pattern", patternName);
                subCompound.func_74768_a("Color", this.remapColor(dyecolor));
                list.func_74742_a((NBTBase)subCompound);
            }
            if (!ItemStack.func_77989_b((ItemStack)outputStack, (ItemStack)this.outputSlot.func_75211_c())) {
                this.outputSlot.func_75215_d(outputStack);
            }
        } else if (index < 0 && this.patternSlot.func_75216_d()) {
            index = MathHelper.func_76130_a((int)index) - 1;
            ItemStack bannerStack = this.bannerSlot.func_75211_c();
            ItemStack dyeStack = this.dyeSlot.func_75211_c();
            ItemStack outputStack = ItemStack.field_190927_a;
            if (!bannerStack.func_190926_b() && !dyeStack.func_190926_b()) {
                NBTTagList list;
                outputStack = bannerStack.func_77946_l();
                outputStack.func_190920_e(1);
                String patternName = index < BannerPatternUtils.getExtraPatternList().size() ? BannerPatternUtils.getExtraPatternList().get(index).func_190993_b() : ((ItemBannerPattern)this.getPatternSlot().func_75211_c().func_77973_b()).getBannerPattern().func_190993_b();
                EnumDyeColor dyecolor = EnumDyeColor.func_176766_a((int)dyeStack.func_77960_j());
                NBTTagCompound baseCompound = outputStack.func_190925_c("BlockEntityTag");
                if (baseCompound.func_150297_b("Patterns", 9)) {
                    list = baseCompound.func_150295_c("Patterns", 10);
                } else {
                    list = new NBTTagList();
                    baseCompound.func_74782_a("Patterns", (NBTBase)list);
                }
                NBTTagCompound subCompound = new NBTTagCompound();
                subCompound.func_74778_a("Pattern", patternName);
                subCompound.func_74768_a("Color", this.remapColor(dyecolor));
                list.func_74742_a((NBTBase)subCompound);
            }
            if (!ItemStack.func_77989_b((ItemStack)outputStack, (ItemStack)this.outputSlot.func_75211_c())) {
                this.outputSlot.func_75215_d(outputStack);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Slot getBannerSlot() {
        return this.bannerSlot;
    }

    @SideOnly(value=Side.CLIENT)
    public Slot getDyeSlot() {
        return this.dyeSlot;
    }

    @SideOnly(value=Side.CLIENT)
    public Slot getPatternSlot() {
        return this.patternSlot;
    }

    @SideOnly(value=Side.CLIENT)
    public Slot getOutputSlot() {
        return this.outputSlot;
    }

    public int remapColor(EnumDyeColor color) {
        return remappedColors.indexOf(color);
    }

    private int indexOfIdInPatternList(List<BannerPattern> list, String hashName) {
        for (BannerPattern pattern : list) {
            if (!pattern.func_190993_b().equals(hashName)) continue;
            return list.indexOf(pattern);
        }
        return -1;
    }
}

