/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.whatloomsahead.client.gui;

import java.io.IOException;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BannerTextures;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import thefloydman.whatloomsahead.inventory.container.ContainerLoom;
import thefloydman.whatloomsahead.tileentity.BannerPatternUtils;
import thefloydman.whatloomsahead.util.WhatLoomsAheadSoundEvents;

@SideOnly(value=Side.CLIENT)
public class GuiLoom
extends GuiContainer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("whatloomsahead", "textures/gui/loom.png");
    private static final int rowsInPatternGrid = (BannerPatternUtils.getMainPatternList().size() - 1 + 4 - 1) / 4;
    private ResourceLocation bannerPreviewTexture;
    private ItemStack field_214119_q = ItemStack.field_190927_a;
    private ItemStack field_214120_r = ItemStack.field_190927_a;
    private ItemStack field_214121_s = ItemStack.field_190927_a;
    private final ResourceLocation[] allMainPatterns = new ResourceLocation[BannerPatternUtils.getMainPatternList().size()];
    private final ResourceLocation[] allExtraPatterns = new ResourceLocation[BannerPatternUtils.getExtraPatternList().size()];
    private boolean regularPatternGridEnabled;
    private boolean bannerPatternInserted;
    private boolean maxPatternsReached;
    private float field_214126_x;
    private boolean mouseClickedInScrollBar;
    private int firstVisiblePattern = 1;
    private int currentMainPattern = 1;
    private int currentExtraPattern = 0;
    private ContainerLoom container;
    private String title;
    private InventoryPlayer playerInventory;

    public GuiLoom(ContainerLoom containerIn, InventoryPlayer inventoryIn, ITextComponent title) {
        super((Container)containerIn);
        containerIn.setRunnable(this::displayBannerPreview);
        this.container = containerIn;
        this.title = "Loom";
        this.playerInventory = inventoryIn;
    }

    public void func_73876_c() {
        BannerPattern pattern;
        super.func_73876_c();
        if (this.currentMainPattern < BannerPatternUtils.getMainPatternList().size()) {
            pattern = BannerPatternUtils.getMainPatternList().get(this.currentMainPattern);
            this.allMainPatterns[this.currentMainPattern] = BannerPatternUtils.getPatternResourceLocation(pattern);
            ++this.currentMainPattern;
        }
        if (this.currentExtraPattern < BannerPatternUtils.getExtraPatternList().size()) {
            pattern = BannerPatternUtils.getExtraPatternList().get(this.currentExtraPattern);
            this.allExtraPatterns[this.currentExtraPattern] = BannerPatternUtils.getPatternResourceLocation(pattern);
            ++this.currentExtraPattern;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.title, 8, 4, 0x404040);
        this.field_146289_q.func_78276_b(this.playerInventory.func_145748_c_().func_150254_d(), 8, this.field_147000_g - 96 + 2, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        int drawLeft = this.field_147003_i;
        int drawTop = this.field_147009_r;
        this.func_73729_b(drawLeft, drawTop, 0, 0, this.field_146999_f, this.field_147000_g);
        Slot bannerSlot = this.container.getBannerSlot();
        Slot dyeSlot = this.container.getDyeSlot();
        Slot patternSlot = this.container.getPatternSlot();
        Slot outputSlot = this.container.getOutputSlot();
        if (!bannerSlot.func_75216_d()) {
            this.func_73729_b(drawLeft + bannerSlot.field_75223_e, drawTop + bannerSlot.field_75221_f, this.field_146999_f, 0, 16, 16);
        }
        if (!dyeSlot.func_75216_d()) {
            this.func_73729_b(drawLeft + dyeSlot.field_75223_e, drawTop + dyeSlot.field_75221_f, this.field_146999_f + 16, 0, 16, 16);
        }
        if (!patternSlot.func_75216_d()) {
            this.func_73729_b(drawLeft + patternSlot.field_75223_e, drawTop + patternSlot.field_75221_f, this.field_146999_f + 32, 0, 16, 16);
        }
        int k = (int)(41.0f * this.field_214126_x);
        this.func_73729_b(drawLeft + 119, drawTop + 13 + k, 232 + (this.regularPatternGridEnabled ? 0 : 12), 0, 12, 15);
        if (this.bannerPreviewTexture != null && !this.maxPatternsReached) {
            this.field_146297_k.func_110434_K().func_110577_a(this.bannerPreviewTexture);
            GuiLoom.func_152125_a((int)(drawLeft + 141), (int)(drawTop + 8), (float)1.0f, (float)1.0f, (int)20, (int)40, (int)20, (int)40, (float)64.0f, (float)64.0f);
        } else if (this.maxPatternsReached) {
            this.func_73729_b(drawLeft + outputSlot.field_75223_e - 2, drawTop + outputSlot.field_75221_f - 2, this.field_146999_f, 17, 17, 16);
        }
        if (this.regularPatternGridEnabled) {
            int patternGridLeft = drawLeft + 60;
            int patternFrigTop = drawTop + 13;
            int firstInvisiblePattern = this.firstVisiblePattern + 16;
            for (int currentCell = this.firstVisiblePattern; currentCell < firstInvisiblePattern && currentCell < BannerPatternUtils.getMainPatternList().size(); ++currentCell) {
                int cellNumber = currentCell - this.firstVisiblePattern;
                int cellLeft = patternGridLeft + cellNumber % 4 * 14;
                int cellTop = patternFrigTop + cellNumber / 4 * 14;
                this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
                int textureY = this.field_147000_g;
                if (currentCell == this.container.getCurrentMainPattern()) {
                    textureY += 14;
                } else if (mouseX >= cellLeft && mouseY >= cellTop && mouseX < cellLeft + 14 && mouseY < cellTop + 14) {
                    textureY += 28;
                }
                this.func_73729_b(cellLeft, cellTop, 0, textureY, 14, 14);
                if (this.allMainPatterns[currentCell] == null) continue;
                this.field_146297_k.func_110434_K().func_110577_a(this.allMainPatterns[currentCell]);
                GuiLoom.func_152125_a((int)(cellLeft + 4), (int)(cellTop + 2), (float)1.0f, (float)1.0f, (int)20, (int)40, (int)5, (int)10, (float)64.0f, (float)64.0f);
            }
        } else if (this.bannerPatternInserted) {
            int l2 = drawLeft + 60;
            int i3 = drawTop + 13;
            this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
            this.func_73729_b(l2, i3, 0, this.field_147000_g, 14, 14);
            int j3 = this.container.getCurrentExtraPattern();
            if (j3 >= 0 && this.allExtraPatterns[j3] != null) {
                this.field_146297_k.func_110434_K().func_110577_a(this.allExtraPatterns[j3]);
                GuiLoom.func_152125_a((int)(l2 + 4), (int)(i3 + 2), (float)1.0f, (float)1.0f, (int)20, (int)40, (int)5, (int)10, (float)64.0f, (float)64.0f);
            }
        }
    }

    public void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.mouseClickedInScrollBar = false;
        if (this.regularPatternGridEnabled) {
            int sectionLeft = this.field_147003_i + 60;
            int sectionTop = this.field_147009_r + 13;
            int k = this.firstVisiblePattern + 16;
            for (int currentCell = this.firstVisiblePattern; currentCell < k; ++currentCell) {
                int i1 = currentCell - this.firstVisiblePattern;
                double d0 = (double)mouseX - (double)(sectionLeft + i1 % 4 * 14);
                double d1 = (double)mouseY - (double)(sectionTop + i1 / 4 * 14);
                if (!(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 14.0) || !(d1 < 14.0) || !this.container.func_75140_a((EntityPlayer)this.field_146297_k.field_71439_g, currentCell)) continue;
                this.field_146297_k.field_71439_g.func_184185_a(WhatLoomsAheadSoundEvents.UI_LOOM_SELECT_PATTERN, 0.25f, 1.0f);
                this.field_146297_k.field_71442_b.func_78756_a(this.container.field_75152_c, currentCell);
                return;
            }
            sectionLeft = this.field_147003_i + 119;
            sectionTop = this.field_147009_r + 9;
            if ((double)mouseX >= (double)sectionLeft && (double)mouseX < (double)(sectionLeft + 12) && (double)mouseY >= (double)sectionTop && (double)mouseY < (double)(sectionTop + 56)) {
                this.mouseClickedInScrollBar = true;
            }
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    private void displayBannerPreview() {
        ItemStack itemStack = this.container.getOutputSlot().func_75211_c();
        if (itemStack.func_190926_b()) {
            this.bannerPreviewTexture = null;
        } else {
            TileEntityBanner tileEntityBanner = new TileEntityBanner();
            tileEntityBanner.func_175112_a(itemStack, false);
            this.bannerPreviewTexture = BannerTextures.field_178466_c.func_187478_a(tileEntityBanner.func_175116_e(), tileEntityBanner.func_175114_c(), tileEntityBanner.func_175110_d());
        }
        ItemStack itemstack3 = this.container.getBannerSlot().func_75211_c();
        ItemStack itemstack1 = this.container.getDyeSlot().func_75211_c();
        ItemStack itemstack2 = this.container.getPatternSlot().func_75211_c();
        NBTTagCompound compoundnbt = itemstack3.func_190925_c("BlockEntityTag");
        boolean bl = this.maxPatternsReached = compoundnbt.func_150297_b("Patterns", 9) && !itemstack3.func_190926_b() && compoundnbt.func_150295_c("Patterns", 10).func_74745_c() >= 6;
        if (this.maxPatternsReached) {
            this.bannerPreviewTexture = null;
        }
        if (!(ItemStack.func_77989_b((ItemStack)itemstack3, (ItemStack)this.field_214119_q) && ItemStack.func_77989_b((ItemStack)itemstack1, (ItemStack)this.field_214120_r) && ItemStack.func_77989_b((ItemStack)itemstack2, (ItemStack)this.field_214121_s))) {
            this.regularPatternGridEnabled = !itemstack3.func_190926_b() && !itemstack1.func_190926_b() && itemstack2.func_190926_b() && !this.maxPatternsReached;
            this.bannerPatternInserted = !this.maxPatternsReached && !itemstack2.func_190926_b() && !itemstack3.func_190926_b() && !itemstack1.func_190926_b();
        }
        this.field_214119_q = itemstack3.func_77946_l();
        this.field_214120_r = itemstack1.func_77946_l();
        this.field_214121_s = itemstack2.func_77946_l();
    }

    public void func_146274_d() throws IOException {
        int guiX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int guiY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        double mouseScrollAmount = Mouse.getEventDWheel() / 120;
        if (!Mouse.getEventButtonState()) {
            this.mouseScrolled(guiX, guiY, mouseScrollAmount);
        }
        super.func_146274_d();
    }

    public void func_146273_a(int mouseX, int mouseY, int lastButtonClicked, long timeSinceMouseClick) {
        if (this.mouseClickedInScrollBar && this.regularPatternGridEnabled) {
            int i = this.field_147009_r + 13;
            int j = i + 56;
            this.field_214126_x = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.field_214126_x = MathHelper.func_76131_a((float)this.field_214126_x, (float)0.0f, (float)1.0f);
            int k = rowsInPatternGrid - 4;
            int l = (int)((double)(this.field_214126_x * (float)k) + 0.5);
            if (l < 0) {
                l = 0;
            }
            this.firstVisiblePattern = 1 + l * 4;
            return;
        }
        super.func_146273_a(mouseX, mouseY, lastButtonClicked, timeSinceMouseClick);
    }

    public void mouseScrolled(int mouseX, int mouseY, double amountScrolled) {
        if (this.regularPatternGridEnabled) {
            int i = rowsInPatternGrid - 4;
            this.field_214126_x = (float)((double)this.field_214126_x - amountScrolled / (double)i);
            this.field_214126_x = MathHelper.func_76131_a((float)this.field_214126_x, (float)0.0f, (float)1.0f);
            this.firstVisiblePattern = 1 + (int)((double)(this.field_214126_x * (float)i) + 0.5) * 4;
        }
    }
}

