/*
 * Decompiled with CFR 0.152.
 */
package com.snowshock35.jeiintegration.config;

import java.io.File;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class Config {
    static final String CATEGORY_HANDLERS = "Handler Settings";
    static final String CATEGORY_TOOLTIPS = "Tooltip Settings";
    static final String CATEGORY_MISCELLANEOUS = "Miscellaneous Settings";
    private static final String defaultBurnTimeTooltipMode = "disabled";
    private static final String defaultDurabilityTooltipMode = "disabled";
    private static final String defaultFluidRegInfoTooltipMode = "disabled";
    private static final String defaultRegistryNameTooltipMode = "disabled";
    private static final String defaultMaxStackSizeTooltipMode = "disabled";
    private static final String defaultMetadataTooltipMode = "disabled";
    private static final String defaultNbtTooltipMode = "disabled";
    private static final String defaultOreDictEntriesTooltipMode = "disabled";
    private static final String defaultUnlocalizedNameTooltipMode = "disabled";
    private final Configuration config;
    private String burnTimeTooltipMode = "";
    private String durabilityTooltipMode = "";
    private String fluidRegInfoTooltipMode = "";
    private String registryNameTooltipMode = "";
    private String maxStackSizeTooltipMode = "";
    private String metadataTooltipMode = "";
    private String nbtTooltipMode = "";
    private String oreDictEntriesTooltipMode = "";
    private String unlocalizedNameTooltipMode = "";

    public Config(FMLPreInitializationEvent e) {
        File configFile = new File(e.getModConfigurationDirectory(), "jeiintegration.cfg");
        this.config = new Configuration(configFile, "1.0.0");
        this.loadConfig();
    }

    private void loadConfig() {
        this.config.setCategoryLanguageKey(CATEGORY_HANDLERS, "config.jeiintegration.handlers");
        this.config.setCategoryLanguageKey(CATEGORY_TOOLTIPS, "config.jeiintegration.tooltips");
        this.config.setCategoryLanguageKey(CATEGORY_MISCELLANEOUS, "config.jeiintegration.miscellaneous");
        this.config.addCustomCategoryComment(CATEGORY_HANDLERS, I18n.func_135052_a((String)"config.jeiintegration.handlers.comment", (Object[])new Object[0]));
        this.config.addCustomCategoryComment(CATEGORY_TOOLTIPS, I18n.func_135052_a((String)"config.jeiintegration.tooltips.comment", (Object[])new Object[0]));
        this.config.addCustomCategoryComment(CATEGORY_MISCELLANEOUS, I18n.func_135052_a((String)"config.jeiintegration.miscellaneous.comment", (Object[])new Object[0]));
        this.burnTimeTooltipMode = this.config.getString("burnTimeTooltipMode", CATEGORY_TOOLTIPS, "disabled", I18n.func_135052_a((String)"config.jeiintegration.tooltips.burnTimeTooltipMode.comment", (Object[])new Object[0]), new String[]{"disabled", "enabled", "onShift", "onDebug", "onShiftAndDebug"}, "config.jeiintegration.tooltips.burnTimeTooltipMode");
        this.durabilityTooltipMode = this.config.getString("durabilityTooltipMode", CATEGORY_TOOLTIPS, "disabled", I18n.func_135052_a((String)"config.jeiintegration.tooltips.durabilityTooltipMode.comment", (Object[])new Object[0]), new String[]{"disabled", "enabled", "onShift", "onDebug", "onShiftAndDebug"}, "config.jeiintegration.tooltips.durabilityTooltipMode");
        this.fluidRegInfoTooltipMode = this.config.getString("fluidRegInfoTooltipMode", CATEGORY_TOOLTIPS, "disabled", I18n.func_135052_a((String)"config.jeiintegration.tooltips.fluidRegInfoTooltipMode.comment", (Object[])new Object[0]), new String[]{"disabled", "enabled", "onShift", "onDebug", "onShiftAndDebug"}, "config.jeiintegration.tooltips.fluidRegInfoTooltipMode");
        this.registryNameTooltipMode = this.config.getString("registryNameTooltipMode", CATEGORY_TOOLTIPS, "disabled", I18n.func_135052_a((String)"config.jeiintegration.tooltips.registryNameTooltipMode.comment", (Object[])new Object[0]), new String[]{"disabled", "enabled", "onShift", "onDebug", "onShiftAndDebug"}, "config.jeiintegration.tooltips.registryNameTooltipMode");
        this.maxStackSizeTooltipMode = this.config.getString("maxStackSizeTooltipMode", CATEGORY_TOOLTIPS, "disabled", I18n.func_135052_a((String)"config.jeiintegration.tooltips.maxStackSizeTooltipMode.comment", (Object[])new Object[0]), new String[]{"disabled", "enabled", "onShift", "onDebug", "onShiftAndDebug"}, "config.jeiintegration.tooltips.maxStackSizeTooltipMode");
        this.metadataTooltipMode = this.config.getString("metadataTooltipMode", CATEGORY_TOOLTIPS, "disabled", I18n.func_135052_a((String)"config.jeiintegration.tooltips.metadataTooltipMode.comment", (Object[])new Object[0]), new String[]{"disabled", "enabled", "onShift", "onDebug", "onShiftAndDebug"}, "config.jeiintegration.tooltips.metadataTooltipMode");
        this.nbtTooltipMode = this.config.getString("nbtTooltipMode", CATEGORY_TOOLTIPS, "disabled", I18n.func_135052_a((String)"config.jeiintegration.tooltips.nbtTooltipMode.comment", (Object[])new Object[0]), new String[]{"disabled", "enabled", "onShift", "onDebug", "onShiftAndDebug"}, "config.jeiintegration.tooltips.nbtTooltipMode");
        this.oreDictEntriesTooltipMode = this.config.getString("oreDictEntriesTooltipMode", CATEGORY_TOOLTIPS, "disabled", I18n.func_135052_a((String)"config.jeiintegration.tooltips.oreDictEntriesTooltipMode.comment", (Object[])new Object[0]), new String[]{"disabled", "enabled", "onShift", "onDebug", "onShiftAndDebug"}, "config.jeiintegration.tooltips.oreDictEntriesTooltipMode");
        this.unlocalizedNameTooltipMode = this.config.getString("unlocalizedNameTooltipMode", CATEGORY_TOOLTIPS, "disabled", I18n.func_135052_a((String)"config.jeiintegration.tooltips.unlocalizedNameTooltipMode.comment", (Object[])new Object[0]), new String[]{"disabled", "enabled", "onShift", "onDebug", "onShiftAndDebug"}, "config.jeiintegration.tooltips.unlocalizedNameTooltipMode");
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public Configuration getConfig() {
        return this.config;
    }

    public String getBurnTimeTooltipMode() {
        return this.burnTimeTooltipMode;
    }

    public String getDurabilityTooltipMode() {
        return this.durabilityTooltipMode;
    }

    public String getFluidRegInfoTooltipMode() {
        return this.fluidRegInfoTooltipMode;
    }

    public String getRegistryNameTooltipMode() {
        return this.registryNameTooltipMode;
    }

    public String getMaxStackSizeTooltipMode() {
        return this.maxStackSizeTooltipMode;
    }

    public String getMetadataTooltipMode() {
        return this.metadataTooltipMode;
    }

    public String getNbtTooltipMode() {
        return this.nbtTooltipMode;
    }

    public String getOreDictEntriesTooltipMode() {
        return this.oreDictEntriesTooltipMode;
    }

    public String getUnlocalizedNameTooltipMode() {
        return this.unlocalizedNameTooltipMode;
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if ("jeiintegration".equals(eventArgs.getModID())) {
            this.loadConfig();
        }
    }
}

