/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.world.biome.data;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.json.JsonFormat;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import logictechcorp.libraryex.utility.FileHelper;
import logictechcorp.libraryex.utility.WorldHelper;
import logictechcorp.libraryex.world.biome.data.BiomeData;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BiomeDataManager {
    private final String modId;
    private final Logger logger;
    private final Map<ResourceLocation, BiomeData> defaultBiomeData;
    private final Map<ResourceLocation, BiomeData> worldSpecificBiomeData;
    private final Map<ResourceLocation, BiomeManager.BiomeEntry> worldSpecificBiomeEntries;

    public BiomeDataManager(String modId, String modName) {
        this.modId = modId;
        this.logger = LogManager.getLogger((String)modName);
        this.defaultBiomeData = new HashMap<ResourceLocation, BiomeData>();
        this.worldSpecificBiomeData = new HashMap<ResourceLocation, BiomeData>();
        this.worldSpecificBiomeEntries = new ConcurrentHashMap<ResourceLocation, BiomeManager.BiomeEntry>();
    }

    public void setup() {
        this.worldSpecificBiomeData.forEach(this.defaultBiomeData::put);
    }

    public void registerBiomeData(BiomeData biomeData) {
        if (biomeData != null && biomeData.getBiome() != null && biomeData != BiomeData.EMPTY) {
            Biome biome = biomeData.getBiome();
            ResourceLocation biomeRegistryName = biome.getRegistryName();
            if (!this.worldSpecificBiomeData.containsKey(biomeRegistryName)) {
                this.worldSpecificBiomeData.put(biomeRegistryName, biomeData);
            }
            if (!biomeData.isSubBiome()) {
                if (biomeData.isEnabled()) {
                    this.worldSpecificBiomeEntries.put(biomeRegistryName, new BiomeManager.BiomeEntry(biome, biomeData.getGenerationWeight()));
                } else {
                    this.worldSpecificBiomeEntries.remove(biomeRegistryName);
                }
            }
        }
    }

    public void unregisterBiomeData(Biome biome) {
        if (biome != null) {
            ResourceLocation biomeRegistryName = biome.getRegistryName();
            this.worldSpecificBiomeData.remove(biomeRegistryName);
            this.worldSpecificBiomeEntries.remove(biomeRegistryName);
        }
    }

    public void cleanup(WorldEvent.Unload event) {
        this.worldSpecificBiomeData.clear();
        this.worldSpecificBiomeEntries.clear();
    }

    public void readBiomeDataConfigs(WorldEvent.Load event) {
        Path path = new File(WorldHelper.getSaveDirectory(event.getWorld()), "/config/" + this.modId + "/nether_biomes/").toPath();
        this.logger.info("Reading Nether biome data configs.");
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            Iterator pathIter = Files.walk(path, new FileVisitOption[0]).iterator();
            while (pathIter.hasNext()) {
                File configFile = ((Path)pathIter.next()).toFile();
                if (FileHelper.getFileExtension(configFile).equals("json")) {
                    String fileText = FileUtils.readFileToString((File)configFile, (Charset)Charset.defaultCharset()).trim();
                    if (fileText.isEmpty() || !fileText.startsWith("{") || !fileText.endsWith("}")) {
                        String filePath = configFile.getPath();
                        String fileBackupPath = filePath + "_backup";
                        Files.move(configFile.toPath(), Paths.get(fileBackupPath, new String[0]), new CopyOption[0]);
                        this.logger.warn("The biome config at {} was invalid and was backed up as {}.", (Object)filePath, (Object)fileBackupPath);
                        continue;
                    }
                    FileConfig config = FileConfig.builder((File)configFile, (ConfigFormat)JsonFormat.fancyInstance()).preserveInsertionOrder().build();
                    config.load();
                    Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation((String)config.get("biome")));
                    if (biome != null) {
                        BiomeData biomeData = this.hasBiomeData(biome) ? this.getBiomeData(biome) : new BiomeData(biome.getRegistryName(), 10, true, false);
                        biomeData.readFromConfig(this, (Config)config);
                        this.registerBiomeData(biomeData);
                    }
                    config.save();
                    config.close();
                    continue;
                }
                if (configFile.isDirectory() || FileHelper.getFileExtension(configFile).equals("json_backup")) continue;
                this.logger.warn("Skipping file located at, {}, as it is not a json file.", (Object)configFile.getPath());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void createBiomeDataConfigs(WorldEvent.Load event) {
        this.logger.info("Creating Nether biome data configs.");
        try {
            for (BiomeData biomeData : this.getDefaultBiomeData().values()) {
                File configFile = new File(WorldHelper.getSaveDirectory(event.getWorld()), "config/" + this.modId + "/nether_biomes/" + biomeData.getBiome().getRegistryName().toString().replace(":", "/") + ".json");
                if (configFile.exists()) continue;
                Files.createDirectories(configFile.getParentFile().toPath(), new FileAttribute[0]);
                FileConfig config = FileConfig.builder((File)configFile, (ConfigFormat)JsonFormat.fancyInstance()).preserveInsertionOrder().build();
                biomeData.writeToConfig((Config)config);
                config.save();
                config.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean hasBiomeData(Biome biome) {
        return this.worldSpecificBiomeData.containsKey(biome.getRegistryName());
    }

    public BiomeData getBiomeData(Biome biome) {
        return this.worldSpecificBiomeData.getOrDefault(biome.getRegistryName(), BiomeData.EMPTY);
    }

    public Map<ResourceLocation, BiomeData> getDefaultBiomeData() {
        return Collections.unmodifiableMap(this.defaultBiomeData);
    }

    public Map<ResourceLocation, BiomeData> getWorldSpecificBiomeData() {
        return Collections.unmodifiableMap(this.worldSpecificBiomeData);
    }

    public Map<ResourceLocation, BiomeManager.BiomeEntry> getWorldSpecificBiomeEntries() {
        return Collections.unmodifiableMap(this.worldSpecificBiomeEntries);
    }
}

