/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.utility;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.json.JsonFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import logictechcorp.libraryex.utility.BlockStateHelper;
import logictechcorp.libraryex.utility.NBTHelper;
import logictechcorp.libraryex.utility.RandomHelper;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ConfigHelper {
    public static IBlockState getBlockState(Config config, String path) {
        if (config.contains(path)) {
            ResourceLocation registryKey = null;
            if (config.get(path + ".block") instanceof String) {
                registryKey = new ResourceLocation((String)config.get(path + ".block"));
            } else if (config.get(path + "itemBlock") instanceof String) {
                registryKey = new ResourceLocation((String)config.get(path + ".itemBlock"));
            }
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(registryKey);
            if (block != null && block != Blocks.field_150350_a) {
                IBlockState state = block.func_176223_P();
                if (config.contains(path + ".properties")) {
                    Config properties = (Config)config.get(path + ".properties");
                    for (Config.Entry entry : properties.entrySet()) {
                        Comparable propertyValue;
                        IProperty property = BlockStateHelper.getProperty(state, entry.getKey());
                        if (property == null || (propertyValue = BlockStateHelper.getPropertyValue(property, (String)entry.getValue())) == null) continue;
                        state = state.func_177226_a(property, propertyValue);
                    }
                }
                return state;
            }
        }
        return null;
    }

    public static ItemStack getItemStack(Config config, String path) {
        if (config.contains(path)) {
            Block block;
            ItemStack stack = ItemStack.field_190927_a;
            if (config.get(path + ".item") instanceof String) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation((String)config.get(path + ".item")));
                if (item != null && item != Items.field_190931_a) {
                    stack = new ItemStack(item, 1, ((Integer)config.getOrElse(path + ".meta", (Object)0)).intValue());
                }
            } else if (config.get(path + ".itemBlock") instanceof String && (block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation((String)config.get(path + ".itemBlock")))) != null && block != Blocks.field_150350_a) {
                IBlockState state = block.func_176223_P();
                if (config.contains(path + ".properties")) {
                    Config propertyConfig = (Config)config.get(path + ".properties");
                    for (Config.Entry entry : propertyConfig.entrySet()) {
                        Comparable propertyValue;
                        IProperty property = BlockStateHelper.getProperty(state, entry.getKey());
                        if (property == null || (propertyValue = BlockStateHelper.getPropertyValue(property, (String)entry.getValue())) == null) continue;
                        state = state.func_177226_a(property, propertyValue);
                    }
                }
                stack = new ItemStack(block, 1, block.func_176201_c(state));
            }
            if (!stack.func_190926_b()) {
                List enchantments;
                List loreList;
                int count = 0;
                if (config.contains(path + ".minCount") || config.contains(path + ".maxCount")) {
                    count = RandomHelper.getNumberInRange((Integer)config.getOrElse(path + ".minCount", (Object)1), (Integer)config.getOrElse(path + ".maxCount", (Object)stack.func_77976_d()), RandomHelper.getRandom());
                } else if (config.contains(path + ".count")) {
                    count = (Integer)config.get(path + ".count");
                }
                if (count < 1) {
                    count = 1;
                    config.set(path + ".minCount", (Object)count);
                } else if (count > stack.func_77976_d()) {
                    count = stack.func_77976_d();
                    config.set(path + ".maxCount", (Object)count);
                }
                stack.func_190920_e(count);
                if (config.contains(path + ".displayName")) {
                    stack.func_151001_c((String)config.get(path + ".displayName"));
                }
                if ((loreList = (List)config.get(path + ".lore")) != null && loreList.size() > 0) {
                    NBTHelper.ensureTagExists(stack);
                    NBTTagList loreTagList = new NBTTagList();
                    for (String lore : loreList) {
                        loreTagList.func_74742_a((NBTBase)new NBTTagString(lore));
                    }
                    NBTTagCompound displayCompound = new NBTTagCompound();
                    displayCompound.func_74782_a("Lore", (NBTBase)loreTagList);
                    NBTTagCompound compound = new NBTTagCompound();
                    compound.func_74782_a("display", (NBTBase)displayCompound);
                    NBTHelper.setTagIfNotExistent(stack, compound);
                }
                if ((enchantments = (List)config.get(path + ".enchantments")) != null) {
                    for (Config enchantmentConfig : enchantments) {
                        Enchantment enchantment = Enchantment.func_180305_b((String)((String)enchantmentConfig.get("enchantment")));
                        if (enchantment == null) continue;
                        int enchantmentLevel = 0;
                        if (enchantmentConfig.contains("minEnchantmentLevel") || enchantmentConfig.contains("maxEnchantmentLevel")) {
                            enchantmentLevel = RandomHelper.getNumberInRange((Integer)enchantmentConfig.getOrElse("minEnchantmentLevel", (Object)enchantment.func_77319_d()), (Integer)enchantmentConfig.getOrElse("maxEnchantmentLevel", (Object)enchantment.func_77325_b()), RandomHelper.getRandom());
                        } else if (enchantmentConfig.contains("enchantmentLevel")) {
                            enchantmentLevel = (Integer)enchantmentConfig.get("enchantmentLevel");
                        }
                        if (enchantmentLevel < enchantment.func_77319_d()) {
                            enchantmentLevel = enchantment.func_77319_d();
                            enchantmentConfig.set("minEnchantmentLevel", (Object)enchantmentLevel);
                        } else if (enchantmentLevel > enchantment.func_77325_b()) {
                            enchantmentLevel = enchantment.func_77325_b();
                            enchantmentConfig.set("maxEnchantmentLevel", (Object)enchantmentLevel);
                        }
                        if (stack.func_77973_b() instanceof ItemEnchantedBook) {
                            ItemEnchantedBook.func_92115_a((ItemStack)stack, (EnchantmentData)new EnchantmentData(enchantment, enchantmentLevel));
                            continue;
                        }
                        stack.func_77966_a(enchantment, enchantmentLevel);
                    }
                }
            }
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static void setBlockState(Config config, String path, IBlockState state) {
        if (state != null) {
            config.set(path + ".block", (Object)state.func_177230_c().getRegistryName().toString());
            if (state != state.func_177230_c().func_176223_P()) {
                for (Map.Entry entry : state.func_177228_b().entrySet()) {
                    config.set(path + ".properties." + ((IProperty)entry.getKey()).func_177701_a(), (Object)((Comparable)entry.getValue()).toString().toLowerCase());
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void setItemStackComplex(Config config, String path, ItemStack stack) {
        if (stack != null) {
            Item item = stack.func_77973_b();
            if (item instanceof ItemBlock) {
                Config propertyConfig = JsonFormat.newConfig(LinkedHashMap::new);
                IBlockState state = ((ItemBlock)item).func_179223_d().func_176203_a(stack.func_77960_j());
                for (Map.Entry entry : state.func_177228_b().entrySet()) {
                    propertyConfig.set(((IProperty)entry.getKey()).func_177701_a(), (Object)((Comparable)entry.getValue()).toString().toLowerCase());
                }
                config.set(path + ".itemBlock", (Object)stack.func_77973_b().getRegistryName().toString());
                config.set(path + ".properties", (Object)propertyConfig);
            } else {
                config.set(path + ".item", (Object)stack.func_77973_b().getRegistryName().toString());
                config.set(path + ".meta", (Object)stack.func_77960_j());
            }
            config.set(path + ".count", (Object)stack.func_190916_E());
            NBTTagCompound display = stack.func_179543_a("display");
            if (display != null) {
                NBTTagList loreList;
                if (display.func_150297_b("Name", 8)) {
                    config.set(path + ".displayName", (Object)stack.func_82833_r());
                }
                ArrayList<String> lore = new ArrayList<String>();
                if (display.func_150299_b("Lore") == 9 && !(loreList = display.func_150295_c("Lore", 8)).func_82582_d()) {
                    void var7_9;
                    boolean bl = false;
                    while (var7_9 < loreList.func_74745_c()) {
                        lore.add(loreList.func_150307_f((int)var7_9));
                        ++var7_9;
                    }
                }
                if (lore.size() > 0) {
                    config.set(path + ".lore", lore);
                }
            }
            if (stack.func_77948_v()) {
                ArrayList<Config> enchantmentConfigs = new ArrayList<Config>();
                for (Map.Entry entry : EnchantmentHelper.func_82781_a((ItemStack)stack).entrySet()) {
                    Config enchantmentConfig = JsonFormat.newConfig(LinkedHashMap::new);
                    enchantmentConfig.set("enchantment", (Object)((Enchantment)entry.getKey()).getRegistryName().toString());
                    enchantmentConfig.set("enchantmentLevel", entry.getValue());
                    enchantmentConfigs.add(enchantmentConfig);
                }
                config.set(path + ".enchantments", enchantmentConfigs);
            }
        }
    }

    public static void setItemStackSimple(Config config, String path, ItemStack stack) {
        if (stack != null) {
            Item item = stack.func_77973_b();
            if (item instanceof ItemBlock) {
                Config propertyConfig = JsonFormat.newConfig(LinkedHashMap::new);
                IBlockState state = ((ItemBlock)item).func_179223_d().func_176203_a(stack.func_77960_j());
                for (Map.Entry entry : state.func_177228_b().entrySet()) {
                    propertyConfig.set(((IProperty)entry.getKey()).func_177701_a(), (Object)((Comparable)entry.getValue()).toString().toLowerCase());
                }
                config.set(path + ".itemBlock", (Object)stack.func_77973_b().getRegistryName().toString());
                config.set(path + ".properties", (Object)propertyConfig);
            } else {
                config.set(path + ".item", (Object)stack.func_77973_b().getRegistryName().toString());
                config.set(path + ".meta", (Object)stack.func_77960_j());
            }
        }
    }
}

