/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.village;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.config.pojo.VillageTradePOJO;
import com.github.tartaricacid.touhoulittlemaid.proxy.CommonProxy;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="touhou_little_maid")
public class VillagerRegistryHandler {
    private static final ResourceLocation PROFESSION = new ResourceLocation("touhou_little_maid", "store_owner_of_kourindou");
    private static final ResourceLocation VILLAGER_TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/villager_rinnosuke.png");
    private static final ResourceLocation ZOMBIE_TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/zombie_rinnosuke.png");
    private static final VillagerRegistry.VillagerProfession STORE_OWNER_OF_KOURINDOU = new VillagerRegistry.VillagerProfession(PROFESSION.toString(), VILLAGER_TEXTURE.toString(), ZOMBIE_TEXTURE.toString());
    private static final VillagerRegistry.VillagerCareer STORE_OWNER_OF_KOURINDOU_CAREER = new VillagerRegistry.VillagerCareer(STORE_OWNER_OF_KOURINDOU, String.format("%s.store_owner_of_kourindou.name", "touhou_little_maid"));

    @SubscribeEvent
    public static void registry(RegistryEvent.Register<VillagerRegistry.VillagerProfession> event) {
        for (VillageTradePOJO trade : CommonProxy.VILLAGE_TRADE) {
            Item in = Item.func_111206_d((String)trade.getIn().getId());
            Item out = Item.func_111206_d((String)trade.getOut().getId());
            EntityVillager.PriceInfo inCount = new EntityVillager.PriceInfo(trade.getIn().getCount().getMin(), trade.getIn().getCount().getMax());
            EntityVillager.PriceInfo outCount = new EntityVillager.PriceInfo(trade.getOut().getCount().getMin(), trade.getOut().getCount().getMax());
            if (in == null || out == null) {
                TouhouLittleMaid.LOGGER.warn("Unable to find the corresponding item: {} or {}", (Object)trade.getIn().getId(), (Object)trade.getOut().getId());
                continue;
            }
            ItemStack inStack = new ItemStack(in, 1, trade.getIn().getMeta());
            ItemStack outStack = new ItemStack(out, 1, trade.getOut().getMeta());
            try {
                if (trade.getIn().getNbt() != null && !"".equals(trade.getIn().getNbt())) {
                    inStack.func_77982_d(JsonToNBT.func_180713_a((String)trade.getIn().getNbt()));
                }
                if (trade.getOut().getNbt() != null && !"".equals(trade.getOut().getNbt())) {
                    outStack.func_77982_d(JsonToNBT.func_180713_a((String)trade.getOut().getNbt()));
                }
            }
            catch (NBTException e) {
                TouhouLittleMaid.LOGGER.warn("NBT data reading exception: {} or {}", (Object)trade.getIn().getId(), (Object)trade.getOut().getId());
            }
            STORE_OWNER_OF_KOURINDOU_CAREER.addTrade(trade.getLevel(), new EntityVillager.ITradeList[]{new ItemStackToItemStack(inStack, inCount, outStack, outCount)});
        }
        event.getRegistry().register((IForgeRegistryEntry)STORE_OWNER_OF_KOURINDOU);
    }

    private static class ItemStackToItemStack
    implements EntityVillager.ITradeList {
        private ItemStack sellItem;
        private ItemStack buyItem;
        private EntityVillager.PriceInfo sellCount;
        private EntityVillager.PriceInfo buyCount;

        public ItemStackToItemStack(ItemStack sellItem, EntityVillager.PriceInfo sellCount, ItemStack buyItem, EntityVillager.PriceInfo buyCount) {
            this.sellItem = sellItem;
            this.sellCount = sellCount;
            this.buyItem = buyItem;
            this.buyCount = buyCount;
        }

        public void func_190888_a(@Nonnull IMerchant merchant, @Nonnull MerchantRecipeList recipeList, @Nonnull Random random) {
            this.sellItem.func_190920_e(this.sellCount.func_179412_a(random));
            this.buyItem.func_190920_e(this.buyCount.func_179412_a(random));
            recipeList.add((Object)new MerchantRecipe(this.sellItem, this.buyItem));
        }
    }
}

