/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import java.util.ArrayList;
import java.util.List;

public final class ParseI18n {
    private static final String I18N_START_CHAR = "{";
    private static final String I18N_END_CHAR = "}";

    private ParseI18n() {
    }

    public static String getI18nKey(String strIn) {
        if (strIn.startsWith(I18N_START_CHAR) && strIn.endsWith(I18N_END_CHAR)) {
            return strIn.substring(1, strIn.length() - 1);
        }
        return strIn;
    }

    public static String parse(String strIn) {
        if (strIn.startsWith(I18N_START_CHAR) && strIn.endsWith(I18N_END_CHAR)) {
            return TouhouLittleMaid.proxy.translate(strIn.substring(1, strIn.length() - 1), new Object[0]);
        }
        return strIn;
    }

    public static List<String> parse(List<String> strIn) {
        ArrayList<String> strOut = new ArrayList<String>();
        for (String str : strIn) {
            strOut.add(ParseI18n.parse(str));
        }
        return strOut;
    }
}

