/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public final class ItemFindUtil {
    private ItemFindUtil() {
    }

    public static int findStackSlot(IItemHandler handler, Predicate<ItemStack> filter) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (!filter.test(stack)) continue;
            return i;
        }
        return -1;
    }

    public static boolean isStackIn(IItemHandler handler, Predicate<ItemStack> filter) {
        return ItemFindUtil.findStackSlot(handler, filter) >= 0;
    }

    public static ItemStack getStack(IItemHandler handler, Predicate<ItemStack> filter) {
        int slotIndex = ItemFindUtil.findStackSlot(handler, filter);
        if (slotIndex >= 0) {
            return handler.getStackInSlot(slotIndex);
        }
        return ItemStack.field_190927_a;
    }
}

