/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import org.apache.commons.io.FileUtils;

public final class GetJarResources {
    private GetJarResources() {
    }

    public static void copyTouhouLittleMaidFolder(String folderPath, Path destPath) {
        GetJarResources.copyFolder(TouhouLittleMaid.class, folderPath, destPath);
    }

    public static void copyFolder(Class clz, String folderPath, Path destPath) {
        try {
            URL url = clz.getResource(folderPath);
            switch (url.getProtocol()) {
                case "file": {
                    FileUtils.copyDirectory((File)new File(url.toURI()), (File)destPath.toFile());
                    break;
                }
                case "jar": {
                    FileSystem fs = FileSystems.newFileSystem(url.toURI(), Collections.emptyMap());
                    GetJarResources.copyFolderFromJar(fs.getPath(folderPath, new String[0]), destPath);
                    fs.close();
                    break;
                }
                default: {
                    throw new NullPointerException();
                }
            }
        }
        catch (IOException | URISyntaxException e) {
            TouhouLittleMaid.LOGGER.error((Object)e);
        }
    }

    private static void copyFolderFromJar(final Path srcPath, final Path destPath) throws IOException {
        Files.createDirectories(destPath, new FileAttribute[0]);
        Files.walkFileTree(srcPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Files.createDirectories(destPath.resolve(srcPath.relativize(dir).toString()), new FileAttribute[0]);
                return super.preVisitDirectory(dir, attrs);
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.copy(file, destPath.resolve(srcPath.relativize(file).toString()), new CopyOption[0]);
                return super.visitFile(file, attrs);
            }
        });
    }
}

