/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.tileentity;

import com.github.tartaricacid.touhoulittlemaid.api.AbstractEntityMaid;
import com.github.tartaricacid.touhoulittlemaid.block.BlockGrid;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;

public class TileEntityGrid
extends TileEntity {
    public final ItemStackHandler handler = new ItemStackHandler(9){

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    public boolean input = true;
    public boolean blacklist = false;
    private Mode mode = Mode.UNKNOWN;
    private ItemStack craftingResult = ItemStack.field_190927_a;
    private List<ItemStack> remainingItems = Collections.EMPTY_LIST;

    private static boolean itemMatches(ItemStack stackA, ItemStack stackB, boolean ignoreNBT) {
        return ItemStack.func_179545_c((ItemStack)stackA, (ItemStack)stackB) && (ignoreNBT || ItemStack.func_77970_a((ItemStack)stackA, (ItemStack)stackB));
    }

    public void refresh() {
        this.func_70296_d();
        if (this.field_145850_b != null) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    public final SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, -1, this.func_189515_b(new NBTTagCompound()));
    }

    public final void onDataPacket(NetworkManager manager, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    @Nonnull
    public final NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public final void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.handler.deserializeNBT(compound);
        this.blacklist = compound.func_74767_n("Blacklist");
        this.input = compound.func_74767_n("Input");
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        this.write(compound);
        return super.func_189515_b(compound);
    }

    public NBTTagCompound write(NBTTagCompound compound) {
        compound.func_179237_a(this.handler.serializeNBT());
        compound.func_74757_a("Blacklist", this.blacklist);
        compound.func_74757_a("Input", this.input);
        return compound;
    }

    public boolean interact(IItemHandlerModifiable items, AbstractEntityMaid maid, boolean simulate) {
        if (this.mode == Mode.UNKNOWN) {
            this.updateMode(null);
        }
        switch (this.mode) {
            case UNKNOWN: {
                return false;
            }
            case ITEM_IO: {
                return this.interactItemIO(items, maid, simulate);
            }
            case CRAFTING: {
                return this.interactCrafting(items, maid, simulate);
            }
        }
        return false;
    }

    public ItemStack getItem(IItemHandler inv) {
        block0: for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            for (int j = 0; j < 9; ++j) {
                ItemStack filterItem = this.handler.getStackInSlot(j);
                if (filterItem.func_190926_b() || !TileEntityGrid.itemMatches(stack, filterItem, true)) continue;
                if (this.blacklist) continue block0;
                return stack;
            }
            if (!this.blacklist) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    private boolean interactItemIO(IItemHandlerModifiable inv, AbstractEntityMaid maid, boolean simulate) {
        IBlockState state = this.func_145838_q().func_176203_a(this.func_145832_p());
        EnumFacing facing = ((BlockGrid.Direction)((Object)state.func_177229_b(BlockGrid.DIRECTION))).face;
        BlockPos offsetPos = this.field_174879_c.func_177972_a(facing.func_176734_d());
        TileEntity tile = this.field_145850_b.func_175625_s(offsetPos);
        if (tile == null || !tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) {
            return false;
        }
        IItemHandler itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing);
        IItemHandlerModifiable src = this.input ? inv : itemHandler;
        IItemHandler dest = this.input ? itemHandler : inv;
        ItemStack matchedStack = this.getItem((IItemHandler)src);
        if (matchedStack.func_190926_b()) {
            return false;
        }
        ItemStack remainStack = ItemHandlerHelper.insertItemStacked((IItemHandler)dest, (ItemStack)matchedStack.func_77946_l(), (boolean)simulate);
        if (matchedStack.func_190916_E() != remainStack.func_190916_E()) {
            if (!simulate) {
                maid.func_184185_a(SoundEvents.field_187638_cR, 0.5f, 1.0f);
                if (this.input) {
                    matchedStack.func_190920_e(remainStack.func_190916_E());
                } else {
                    for (int i = 0; i < itemHandler.getSlots(); ++i) {
                        ItemStack s = itemHandler.getStackInSlot(i);
                        if (matchedStack != s) continue;
                        int amount = matchedStack.func_190916_E() - remainStack.func_190916_E();
                        itemHandler.extractItem(i, amount, false);
                        break;
                    }
                }
            }
            return true;
        }
        return false;
    }

    private boolean interactCrafting(IItemHandlerModifiable inv, AbstractEntityMaid maid, boolean simulate) {
        ItemStack result = this.getCraftingResult();
        if (result.func_190926_b()) {
            return false;
        }
        ArrayList ingredients = Lists.newArrayList();
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.handler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            boolean flag = false;
            for (ItemStack ingredient : ingredients) {
                if (!TileEntityGrid.itemMatches(stack, ingredient, false)) continue;
                ingredient.func_190917_f(1);
                flag = true;
            }
            if (flag) continue;
            ingredients.add(stack.func_77946_l());
        }
        if (ingredients.isEmpty()) {
            return false;
        }
        boolean hasEmptySlot = false;
        int sameCount = 0;
        Object2IntArrayMap ingredientsCount = new Object2IntArrayMap();
        HashMultimap matchedItems = HashMultimap.create();
        block2: for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.func_190926_b()) {
                hasEmptySlot = true;
                continue;
            }
            if (TileEntityGrid.itemMatches(stack, result, false)) {
                sameCount += result.func_77976_d() - stack.func_190916_E();
            }
            for (ItemStack ingredient : ingredients) {
                if (!TileEntityGrid.itemMatches(stack, ingredient, false)) continue;
                matchedItems.put((Object)ingredient, (Object)stack);
                int c0 = (Integer)ingredientsCount.getOrDefault((Object)ingredient, (Object)0);
                ingredientsCount.put((Object)ingredient, c0 + stack.func_190916_E());
                continue block2;
            }
        }
        if (ingredients.size() != matchedItems.size()) {
            return false;
        }
        int expectedCount = result.func_77976_d();
        for (Map.Entry entry : ingredientsCount.entrySet()) {
            int count = (Integer)entry.getValue() / ((ItemStack)entry.getKey()).func_190916_E();
            expectedCount = Math.min(expectedCount, count);
        }
        if (expectedCount == 0) {
            return false;
        }
        if (!hasEmptySlot) {
            block5: for (ItemStack stack : ingredientsCount.keySet()) {
                int newCount = expectedCount * stack.func_190916_E();
                for (ItemStack s : matchedItems.get((Object)stack)) {
                    if (newCount < s.func_190916_E()) continue;
                    hasEmptySlot = true;
                    continue block5;
                }
            }
        }
        int minCount = expectedCount;
        if (!hasEmptySlot) {
            minCount = Math.min(sameCount, minCount);
        }
        if (minCount == 0) {
            return false;
        }
        if (simulate) {
            return true;
        }
        for (ItemStack stack : ingredientsCount.keySet()) {
            int newCount = minCount * stack.func_190916_E();
            ingredientsCount.put((Object)stack, newCount);
        }
        block8: for (ItemStack ingredient : matchedItems.keySet()) {
            int count = ingredientsCount.getInt((Object)ingredient);
            ArrayList stacks = Lists.newArrayList((Iterable)matchedItems.get((Object)ingredient));
            stacks.sort(Comparator.comparingInt(ItemStack::func_190916_E));
            for (ItemStack stack : stacks) {
                int shrink = Math.min(stack.func_190916_E(), count);
                stack.func_190918_g(shrink);
                if ((count -= shrink) > 0) continue;
                continue block8;
            }
        }
        result = result.func_77946_l();
        result.func_190920_e(result.func_190916_E() * minCount);
        ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)result, (boolean)false);
        for (ItemStack stack : this.remainingItems) {
            if (stack.func_190926_b()) continue;
            stack = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() * minCount));
            while (!stack.func_190926_b()) {
                ItemStack split = stack.func_77979_a(stack.func_77976_d());
                ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)split, (boolean)false);
                if (remainder.func_190926_b() || this.field_145850_b.field_72995_K) continue;
                EntityItem entityitem = new EntityItem(this.field_145850_b, maid.field_70165_t, maid.field_70163_u + 0.5, maid.field_70161_v, remainder);
                entityitem.func_174867_a(40);
                entityitem.field_70159_w = 0.0;
                entityitem.field_70179_y = 0.0;
                this.field_145850_b.func_72838_d((Entity)entityitem);
            }
        }
        maid.func_184185_a(SoundEvents.field_187638_cR, 0.5f, 1.0f);
        return true;
    }

    private ItemStack getCraftingResult() {
        if (this.craftingResult.func_190926_b()) {
            IRecipe recipe;
            Container container = new Container(){

                public boolean func_75145_c(@Nonnull EntityPlayer playerIn) {
                    return false;
                }
            };
            InventoryCrafting inventoryCrafting = new InventoryCrafting(container, 3, 3);
            boolean empty = true;
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = this.handler.getStackInSlot(i);
                if (!stack.func_190926_b()) {
                    empty = false;
                }
                inventoryCrafting.func_70299_a(i, stack);
            }
            if (!empty && (recipe = CraftingManager.func_192413_b((InventoryCrafting)inventoryCrafting, (World)this.field_145850_b)) != null) {
                this.craftingResult = recipe.func_77572_b(inventoryCrafting);
                this.remainingItems = recipe.func_179532_b(inventoryCrafting);
            }
        }
        return this.craftingResult;
    }

    public void clearCraftingResult() {
        this.craftingResult = ItemStack.field_190927_a;
        this.remainingItems = Collections.EMPTY_LIST;
    }

    public Mode updateMode(@Nullable IBlockState state) {
        TileEntity tile;
        EnumFacing facing;
        BlockPos offsetPos;
        IBlockState offsetState;
        if (state == null) {
            state = this.func_145838_q().func_176203_a(this.func_145832_p());
        }
        if ((offsetState = this.field_145850_b.func_180495_p(offsetPos = this.field_174879_c.func_177972_a((facing = ((BlockGrid.Direction)((Object)state.func_177229_b(BlockGrid.DIRECTION))).face).func_176734_d()))).func_177230_c() == Blocks.field_150462_ai) {
            this.mode = Mode.CRAFTING;
            return this.mode;
        }
        if (OreDictionary.doesOreNameExist((String)"workbench")) {
            ItemStack stack = offsetState.func_177230_c().func_185473_a(this.field_145850_b, offsetPos, offsetState);
            int id = OreDictionary.getOreID((String)"workbench");
            if (!stack.func_190926_b() && ArrayUtils.contains((int[])OreDictionary.getOreIDs((ItemStack)stack), (int)id)) {
                this.mode = Mode.CRAFTING;
                return this.mode;
            }
        }
        if ((tile = this.field_145850_b.func_175625_s(offsetPos)) != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) {
            this.mode = Mode.ITEM_IO;
            return this.mode;
        }
        this.mode = Mode.UNKNOWN;
        return this.mode;
    }

    public boolean isCleared() {
        if (this.input && !this.blacklist) {
            for (int i = 0; i < this.handler.getSlots(); ++i) {
                if (this.handler.getStackInSlot(i).func_190926_b()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static enum Mode {
        UNKNOWN,
        ITEM_IO,
        CRAFTING;

    }
}

