/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.tileentity;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityAltar
extends TileEntity {
    public final ItemStackHandler handler = new ItemStackHandler(){

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    private boolean isRender = false;
    private boolean canPlaceItem = false;
    private IBlockState blockState = Blocks.field_150350_a.func_176223_P();
    private List<BlockPos> blockPosList = Lists.newArrayList();
    private List<BlockPos> canPlaceItemPosList = Lists.newArrayList();
    private EnumFacing facing = EnumFacing.SOUTH;

    public void setForgeData(IBlockState blockState, boolean isRender, boolean canPlaceItem, EnumFacing facing, List<BlockPos> blockPosList, List<BlockPos> canPlaceItemPosList) {
        this.isRender = isRender;
        this.canPlaceItem = canPlaceItem;
        this.blockState = blockState;
        this.facing = facing;
        this.blockPosList = blockPosList;
        this.canPlaceItemPosList = canPlaceItemPosList;
        this.refresh();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        this.getTileData().func_74757_a(NBT.IS_RENDER.getName(), this.isRender);
        this.getTileData().func_74757_a(NBT.CAN_PLACE_ITEM.getName(), this.canPlaceItem);
        this.getTileData().func_74768_a(NBT.STORAGE_STATE_ID.getName(), Block.func_176210_f((IBlockState)this.blockState));
        this.getTileData().func_74782_a(NBT.STORAGE_ITEM.getName(), (NBTBase)this.handler.serializeNBT());
        this.getTileData().func_74768_a(NBT.FACING.getName(), this.facing.func_176745_a());
        NBTTagList blockList = new NBTTagList();
        for (BlockPos pos : this.blockPosList) {
            blockList.func_74742_a((NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
        }
        this.getTileData().func_74782_a(NBT.STORAGE_BLOCK_LIST.getName(), (NBTBase)blockList);
        NBTTagList itemList = new NBTTagList();
        for (BlockPos pos : this.canPlaceItemPosList) {
            itemList.func_74742_a((NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
        }
        this.getTileData().func_74782_a(NBT.CAN_PLACE_ITEM_POS_LIST.getName(), (NBTBase)itemList);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.isRender = this.getTileData().func_74767_n(NBT.IS_RENDER.getName());
        this.canPlaceItem = this.getTileData().func_74767_n(NBT.CAN_PLACE_ITEM.getName());
        this.blockState = Block.func_176220_d((int)this.getTileData().func_74762_e(NBT.STORAGE_STATE_ID.getName()));
        this.handler.deserializeNBT(this.getTileData().func_74775_l(NBT.STORAGE_ITEM.getName()));
        this.facing = EnumFacing.func_82600_a((int)this.getTileData().func_74762_e(NBT.FACING.getName()));
        this.blockPosList.clear();
        NBTTagList blockList = this.getTileData().func_150295_c(NBT.STORAGE_BLOCK_LIST.getName(), 10);
        for (int i = 0; i < blockList.func_74745_c(); ++i) {
            this.blockPosList.add(NBTUtil.func_186861_c((NBTTagCompound)blockList.func_150305_b(i)));
        }
        this.canPlaceItemPosList.clear();
        NBTTagList itemList = this.getTileData().func_150295_c(NBT.CAN_PLACE_ITEM_POS_LIST.getName(), 10);
        for (int i = 0; i < itemList.func_74745_c(); ++i) {
            this.canPlaceItemPosList.add(NBTUtil.func_186861_c((NBTTagCompound)itemList.func_150305_b(i)));
        }
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-9, -5, -9), this.field_174879_c.func_177982_a(9, 5, 9));
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nonnull
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), -1, this.func_189515_b(new NBTTagCompound()));
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void refresh() {
        this.func_70296_d();
        if (this.field_145850_b != null) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    public boolean isRender() {
        return this.isRender;
    }

    public boolean isCanPlaceItem() {
        return this.canPlaceItem;
    }

    public IBlockState getBlockState() {
        return this.blockState;
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public List<BlockPos> getBlockPosList() {
        return this.blockPosList;
    }

    public List<BlockPos> getCanPlaceItemPosList() {
        return this.canPlaceItemPosList;
    }

    public static enum NBT {
        STORAGE_ITEM("StorageItem"),
        IS_RENDER("IsRender"),
        CAN_PLACE_ITEM("CanPlaceItem"),
        STORAGE_STATE_ID("StorageBlockStateId"),
        FACING("Facing"),
        STORAGE_BLOCK_LIST("StorageBlockList"),
        CAN_PLACE_ITEM_POS_LIST("CanPlaceItemPosList");

        private String name;

        private NBT(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

