/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.simpleimpl;

import com.github.tartaricacid.touhoulittlemaid.capability.CapabilityPowerHandler;
import com.github.tartaricacid.touhoulittlemaid.capability.PowerHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SyncPowerMessage
implements IMessage {
    private float power;

    public SyncPowerMessage() {
    }

    public SyncPowerMessage(float power) {
        this.power = power;
    }

    public void fromBytes(ByteBuf buf) {
        this.power = buf.readFloat();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeFloat(this.power);
    }

    public float getPower() {
        return this.power;
    }

    public static class Handler
    implements IMessageHandler<SyncPowerMessage, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(SyncPowerMessage message, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                Minecraft.func_71410_x().func_152344_a(() -> {
                    EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                    if (player == null) {
                        return;
                    }
                    PowerHandler power = (PowerHandler)player.getCapability(CapabilityPowerHandler.POWER_CAP, null);
                    if (power != null) {
                        power.set(message.getPower());
                    }
                });
            }
            return null;
        }
    }
}

