/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.simpleimpl;

import com.github.tartaricacid.touhoulittlemaid.capability.CapabilityPowerHandler;
import com.github.tartaricacid.touhoulittlemaid.capability.PowerHandler;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityMaidBeacon;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class StorageAndTakePowerMessage
implements IMessage {
    private UUID playerUuid;
    private BlockPos pos;
    private float powerNum;
    private boolean isStorage;

    public StorageAndTakePowerMessage() {
    }

    public StorageAndTakePowerMessage(UUID playerUuid, BlockPos pos, float powerNum, boolean isStorage) {
        this.playerUuid = playerUuid;
        this.pos = pos;
        this.powerNum = powerNum;
        this.isStorage = isStorage;
    }

    private static void onStorageAndTake(TileEntityMaidBeacon beacon, EntityPlayer player, float powerNum, boolean isStorage) {
        PowerHandler powerHandler = (PowerHandler)player.getCapability(CapabilityPowerHandler.POWER_CAP, null);
        if (powerHandler != null) {
            if (isStorage) {
                StorageAndTakePowerMessage.storageLogic(powerNum, powerHandler, beacon);
            } else {
                StorageAndTakePowerMessage.takeLogic(powerNum, powerHandler, beacon);
            }
        }
    }

    private static void storageLogic(float powerNum, PowerHandler playerPower, TileEntityMaidBeacon beacon) {
        boolean beaconNotFull;
        boolean playerPowerIsEnough = powerNum <= playerPower.get();
        boolean bl = beaconNotFull = powerNum + beacon.getStoragePower() <= beacon.getMaxStorage();
        if (playerPowerIsEnough) {
            if (beaconNotFull) {
                playerPower.min(powerNum);
                beacon.setStoragePower(beacon.getStoragePower() + powerNum);
            } else {
                playerPower.min(beacon.getMaxStorage() - beacon.getStoragePower());
                beacon.setStoragePower(beacon.getMaxStorage());
            }
        }
    }

    private static void takeLogic(float powerNum, PowerHandler playerPower, TileEntityMaidBeacon beacon) {
        boolean playerNotFull;
        boolean beaconIsEnough = powerNum <= beacon.getStoragePower();
        boolean bl = playerNotFull = powerNum + playerPower.get() < 5.0f;
        if (beaconIsEnough) {
            if (playerNotFull) {
                beacon.setStoragePower(beacon.getStoragePower() - powerNum);
                playerPower.add(powerNum);
            } else {
                beacon.setStoragePower(beacon.getStoragePower() - 5.0f + playerPower.get());
                playerPower.set(5.0f);
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.playerUuid = new UUID(buf.readLong(), buf.readLong());
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.powerNum = buf.readFloat();
        this.isStorage = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.playerUuid.getMostSignificantBits());
        buf.writeLong(this.playerUuid.getLeastSignificantBits());
        buf.writeLong(this.pos.func_177986_g());
        buf.writeFloat(this.powerNum);
        buf.writeBoolean(this.isStorage);
    }

    public static class Handler
    implements IMessageHandler<StorageAndTakePowerMessage, IMessage> {
        public IMessage onMessage(StorageAndTakePowerMessage message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
                    Entity entity = FMLCommonHandler.instance().getMinecraftServerInstance().func_175576_a(message.playerUuid);
                    if (entity instanceof EntityPlayer) {
                        EntityPlayer player = (EntityPlayer)entity;
                        World world = player.field_70170_p;
                        TileEntity te = world.func_175625_s(message.pos);
                        if (te instanceof TileEntityMaidBeacon) {
                            StorageAndTakePowerMessage.onStorageAndTake((TileEntityMaidBeacon)te, player, message.powerNum, message.isStorage);
                        }
                    }
                });
            }
            return null;
        }
    }
}

