/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.simpleimpl;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class SetMaidSasimonoCRC32
implements IMessage {
    private UUID entityUuid;
    private Long crc32;
    private boolean isShow;

    public SetMaidSasimonoCRC32() {
    }

    public SetMaidSasimonoCRC32(UUID entityUuid, Long crc32, boolean isShow) {
        this.entityUuid = entityUuid;
        this.crc32 = crc32;
        this.isShow = isShow;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityUuid = new UUID(buf.readLong(), buf.readLong());
        this.crc32 = buf.readLong();
        this.isShow = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.entityUuid.getMostSignificantBits());
        buf.writeLong(this.entityUuid.getLeastSignificantBits());
        buf.writeLong(this.crc32.longValue());
        buf.writeBoolean(this.isShow);
    }

    public UUID getEntityUuid() {
        return this.entityUuid;
    }

    public Long getCRC32() {
        return this.crc32;
    }

    public boolean isShow() {
        return this.isShow;
    }

    public static class Handler
    implements IMessageHandler<SetMaidSasimonoCRC32, IMessage> {
        public IMessage onMessage(SetMaidSasimonoCRC32 message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
                    Entity entity = FMLCommonHandler.instance().getMinecraftServerInstance().func_175576_a(message.getEntityUuid());
                    if (entity instanceof EntityMaid) {
                        ((EntityMaid)entity).setSasimonoCRC32(message.getCRC32());
                        ((EntityMaid)entity).setShowSasimono(message.isShow());
                    }
                });
            }
            return null;
        }
    }
}

