/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.simpleimpl;

import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityMaidBeacon;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class SetBeaconPotionMessage
implements IMessage {
    private UUID playerUuid;
    private BlockPos pos;
    private int potionIndex;

    public SetBeaconPotionMessage() {
    }

    public SetBeaconPotionMessage(UUID playerUuid, BlockPos pos, int potionIndex) {
        this.playerUuid = playerUuid;
        this.pos = pos;
        this.potionIndex = potionIndex;
    }

    public void fromBytes(ByteBuf buf) {
        this.playerUuid = new UUID(buf.readLong(), buf.readLong());
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.potionIndex = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.playerUuid.getMostSignificantBits());
        buf.writeLong(this.playerUuid.getLeastSignificantBits());
        buf.writeLong(this.pos.func_177986_g());
        buf.writeInt(this.potionIndex);
    }

    public static class Handler
    implements IMessageHandler<SetBeaconPotionMessage, IMessage> {
        public IMessage onMessage(SetBeaconPotionMessage message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
                    Entity entity = FMLCommonHandler.instance().getMinecraftServerInstance().func_175576_a(message.playerUuid);
                    if (entity instanceof EntityPlayer) {
                        EntityPlayer player = (EntityPlayer)entity;
                        World world = player.field_70170_p;
                        TileEntity te = world.func_175625_s(message.pos);
                        if (te instanceof TileEntityMaidBeacon) {
                            ((TileEntityMaidBeacon)te).setPotionIndex(message.potionIndex);
                        }
                    }
                });
            }
            return null;
        }
    }
}

