/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.simpleimpl;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;

public class SendNpcMaidModelMessage
implements IMessage {
    private UUID entityUuid;
    private String modelId;
    private String modelRes;

    public SendNpcMaidModelMessage() {
    }

    public SendNpcMaidModelMessage(UUID entityUuid, String modelId, String modelRes) {
        this.entityUuid = entityUuid;
        this.modelId = modelId;
        this.modelRes = modelRes;
    }

    private static void applyModel(EntityCustomNpc npc, String modelId, String modelRes) {
        EntityLivingBase entity = npc.modelData.getEntity((EntityNPCInterface)npc);
        if (entity instanceof EntityMaid) {
            npc.modelData.extra.func_74778_a("ModelId", modelId);
            npc.display.setSkinTexture(modelRes);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.entityUuid = new UUID(buf.readLong(), buf.readLong());
        this.modelId = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.modelRes = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.entityUuid.getMostSignificantBits());
        buf.writeLong(this.entityUuid.getLeastSignificantBits());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.modelId);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.modelRes);
    }

    private UUID getEntityUuid() {
        return this.entityUuid;
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getModelRes() {
        return this.modelRes;
    }

    public static class Handler
    implements IMessageHandler<SendNpcMaidModelMessage, IMessage> {
        public IMessage onMessage(SendNpcMaidModelMessage message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
                    Entity entity = FMLCommonHandler.instance().getMinecraftServerInstance().func_175576_a(message.getEntityUuid());
                    if (entity instanceof EntityCustomNpc) {
                        SendNpcMaidModelMessage.applyModel((EntityCustomNpc)entity, message.getModelId(), message.getModelRes());
                    }
                });
            }
            return null;
        }
    }
}

