/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.simpleimpl;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MaidHomeModeMessage
implements IMessage {
    private UUID entityUuid;
    private boolean home;

    public MaidHomeModeMessage() {
    }

    public MaidHomeModeMessage(UUID entityUuid, boolean home) {
        this.entityUuid = entityUuid;
        this.home = home;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityUuid = new UUID(buf.readLong(), buf.readLong());
        this.home = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.entityUuid.getMostSignificantBits());
        buf.writeLong(this.entityUuid.getLeastSignificantBits());
        buf.writeBoolean(this.home);
    }

    public boolean isHome() {
        return this.home;
    }

    public UUID getEntityUuid() {
        return this.entityUuid;
    }

    public static class Handler
    implements IMessageHandler<MaidHomeModeMessage, IMessage> {
        public IMessage onMessage(MaidHomeModeMessage message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
                    Entity entity = FMLCommonHandler.instance().getMinecraftServerInstance().func_175576_a(message.getEntityUuid());
                    if (entity instanceof EntityMaid) {
                        ((EntityMaid)entity).setHome(message.isHome());
                    }
                });
            }
            return null;
        }
    }
}

