/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.simpleimpl;

import com.github.tartaricacid.touhoulittlemaid.config.GeneralConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class ApplyMaidSkinDataMessage
implements IMessage {
    private UUID entityUuid;
    private ResourceLocation modelId;

    public ApplyMaidSkinDataMessage() {
    }

    public ApplyMaidSkinDataMessage(UUID entityUuid, ResourceLocation modelId) {
        this.entityUuid = entityUuid;
        this.modelId = modelId;
    }

    private static void applyModelId(EntityMaid maid, String modelId) {
        EntityLivingBase owner = maid.func_70902_q();
        if (owner instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)owner;
            if (player.func_184812_l_() || !GeneralConfig.MAID_CONFIG.maidCannotChangeModel) {
                maid.setModelId(modelId);
            } else {
                ApplyMaidSkinDataMessage.sendMessageToOwner(player);
            }
        }
    }

    private static void sendMessageToOwner(EntityPlayer entityPlayer) {
        if (entityPlayer.func_70089_S()) {
            entityPlayer.func_145747_a((ITextComponent)new TextComponentTranslation("message.touhou_little_maid.change_model.disabled", new Object[0]));
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.entityUuid = new UUID(buf.readLong(), buf.readLong());
        this.modelId = new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf));
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.entityUuid.getMostSignificantBits());
        buf.writeLong(this.entityUuid.getLeastSignificantBits());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.modelId.toString());
    }

    private UUID getEntityUuid() {
        return this.entityUuid;
    }

    public ResourceLocation getModelId() {
        return this.modelId;
    }

    public static class Handler
    implements IMessageHandler<ApplyMaidSkinDataMessage, IMessage> {
        public IMessage onMessage(ApplyMaidSkinDataMessage message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
                    Entity entity = FMLCommonHandler.instance().getMinecraftServerInstance().func_175576_a(message.getEntityUuid());
                    if (entity instanceof EntityMaid) {
                        ApplyMaidSkinDataMessage.applyModelId((EntityMaid)entity, message.getModelId().toString());
                    }
                });
            }
            return null;
        }
    }
}

