/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.danmaku.CustomSpellCardEntry;
import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import com.github.tartaricacid.touhoulittlemaid.proxy.ClientProxy;
import com.github.tartaricacid.touhoulittlemaid.proxy.CommonProxy;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSpellCard
extends Item {
    private static final String SPELL_CARD_ENTRY_TAG = "SpellCardEntry";

    public ItemSpellCard() {
        this.func_77655_b("touhou_little_maid.spell_card");
        this.func_77625_d(1);
        this.func_77637_a(MaidItems.SPELL_CARD_TABS);
    }

    public static ItemStack setCustomSpellCardEntry(String id, ItemStack spellCard) {
        if (spellCard.func_77973_b() == MaidItems.SPELL_CARD) {
            NBTTagCompound tag = spellCard.func_77942_o() ? spellCard.func_77978_p() : new NBTTagCompound();
            tag.func_74778_a(SPELL_CARD_ENTRY_TAG, id);
            spellCard.func_77982_d(tag);
        }
        return spellCard;
    }

    @Nullable
    public static CustomSpellCardEntry getCustomSpellCardEntry(ItemStack spellCard, Map<String, CustomSpellCardEntry> map) {
        String id;
        if (map.isEmpty()) {
            return null;
        }
        CustomSpellCardEntry defaultEntry = map.values().stream().findFirst().get();
        if (spellCard.func_77973_b() == MaidItems.SPELL_CARD && spellCard.func_77942_o() && !(id = spellCard.func_77978_p().func_74779_i(SPELL_CARD_ENTRY_TAG)).isEmpty()) {
            return map.getOrDefault(id, defaultEntry);
        }
        return defaultEntry;
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            Set<String> ids = FMLCommonHandler.instance().getSide().isClient() ? ClientProxy.CUSTOM_SPELL_CARD_MAP_CLIENT.keySet() : CommonProxy.CUSTOM_SPELL_CARD_MAP_SERVER.keySet();
            for (String id : ids) {
                items.add((Object)ItemSpellCard.setCustomSpellCardEntry(id, new ItemStack((Item)this)));
            }
        }
    }

    public String func_77653_i(ItemStack stack) {
        Map<String, CustomSpellCardEntry> map = FMLCommonHandler.instance().getSide().isClient() ? ClientProxy.CUSTOM_SPELL_CARD_MAP_CLIENT : CommonProxy.CUSTOM_SPELL_CARD_MAP_SERVER;
        CustomSpellCardEntry entry = ItemSpellCard.getCustomSpellCardEntry(stack, map);
        if (entry == null) {
            return "";
        }
        return TextFormatting.GOLD + I18n.func_74838_a((String)entry.getNameKey());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        CustomSpellCardEntry entry = ItemSpellCard.getCustomSpellCardEntry(stack, ClientProxy.CUSTOM_SPELL_CARD_MAP_CLIENT);
        if (entry == null) {
            return;
        }
        if (!entry.getDescriptionKey().isEmpty()) {
            tooltip.add(net.minecraft.client.resources.I18n.func_135052_a((String)entry.getDescriptionKey(), (Object[])new Object[0]));
        }
        if (!entry.getAuthor().isEmpty()) {
            tooltip.add("\u00a7a\u258d\u00a0\u00a77" + net.minecraft.client.resources.I18n.func_135052_a((String)"tooltips.touhou_little_maid.spell_card.author", (Object[])new Object[]{entry.getAuthor()}));
        }
        if (!entry.getVersion().isEmpty()) {
            tooltip.add("\u00a7a\u258d\u00a0\u00a77" + net.minecraft.client.resources.I18n.func_135052_a((String)"tooltips.touhou_little_maid.spell_card.version", (Object[])new Object[]{entry.getVersion()}));
        }
        tooltip.add("\u00a7a\u258d\u00a0\u00a77" + net.minecraft.client.resources.I18n.func_135052_a((String)"tooltips.touhou_little_maid.spell_card.cooldown", (Object[])new Object[]{entry.getCooldown()}));
    }
}

