/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.block.BlockMaidBeacon;
import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityMaidBeacon;
import java.text.DecimalFormat;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemMaidBeacon
extends Item {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.00");
    private static final String STORAGE_DATA_TAG = "StorageData";
    private Block block;

    public ItemMaidBeacon(Block block) {
        this.func_77655_b("touhou_little_maid.maid_beacon");
        this.func_77637_a(MaidItems.MAIN_TABS);
        this.block = block;
    }

    public static ItemStack tileEntityToItemStack(TileEntityMaidBeacon beacon) {
        ItemStack stack = new ItemStack(MaidItems.MAID_BEACON);
        NBTTagCompound storageTag = new NBTTagCompound();
        NBTTagCompound stackTag = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        stackTag.func_74782_a(STORAGE_DATA_TAG, (NBTBase)beacon.writeBeaconNBT(storageTag));
        stack.func_77982_d(stackTag);
        return stack;
    }

    private static void itemStackToTileEntity(ItemStack stack, TileEntityMaidBeacon beacon) {
        NBTTagCompound stackTag;
        if (stack.func_77942_o() && (stackTag = stack.func_77978_p()).func_74764_b(STORAGE_DATA_TAG)) {
            NBTTagCompound storageTag = stackTag.func_74775_l(STORAGE_DATA_TAG);
            beacon.readBeaconNBT(storageTag);
        }
    }

    private static void placeBeacon(World worldIn, BlockPos pos, EnumFacing facing, Block beacon, ItemStack stack) {
        BlockPos posUp = pos.func_177984_a();
        IBlockState stateUp = facing == EnumFacing.SOUTH || facing == EnumFacing.NORTH ? beacon.func_176223_P().func_177226_a(BlockMaidBeacon.POSITION, (Comparable)((Object)BlockMaidBeacon.Position.UP_N_S)) : beacon.func_176223_P().func_177226_a(BlockMaidBeacon.POSITION, (Comparable)((Object)BlockMaidBeacon.Position.UP_W_E));
        worldIn.func_180501_a(pos, beacon.func_176223_P(), 2);
        worldIn.func_180501_a(posUp, stateUp, 2);
        worldIn.func_175685_c(pos, beacon, false);
        worldIn.func_175685_c(posUp, beacon, false);
        TileEntity te = worldIn.func_175625_s(posUp);
        if (te instanceof TileEntityMaidBeacon) {
            TileEntityMaidBeacon tileEntityMaidBeacon = (TileEntityMaidBeacon)te;
            ItemMaidBeacon.itemStackToTileEntity(stack, tileEntityMaidBeacon);
            tileEntityMaidBeacon.func_70296_d();
        }
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack;
        if (facing != EnumFacing.UP) {
            return EnumActionResult.FAIL;
        }
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (!block.func_176200_f((IBlockAccess)worldIn, pos)) {
            pos = pos.func_177972_a(facing);
        }
        if (player.func_175151_a(pos, facing, itemstack = player.func_184586_b(hand)) && this.block.func_176196_c(worldIn, pos)) {
            EnumFacing enumfacing = EnumFacing.func_176733_a((double)player.field_70177_z);
            ItemMaidBeacon.placeBeacon(worldIn, pos, enumfacing, this.block, itemstack);
            SoundType soundtype = worldIn.func_180495_p(pos).func_177230_c().getSoundType(worldIn.func_180495_p(pos), worldIn, pos, (Entity)player);
            worldIn.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            itemstack.func_190918_g(1);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        NBTTagCompound stackTag;
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        float numPower = 0.0f;
        if (stack.func_77942_o() && (stackTag = stack.func_77978_p()).func_74764_b(STORAGE_DATA_TAG)) {
            NBTTagCompound storageTag = stackTag.func_74775_l(STORAGE_DATA_TAG);
            numPower = storageTag.func_74760_g("StoragePower");
        }
        tooltip.add(I18n.func_135052_a((String)"tooltips.touhou_little_maid.maid_beacon.desc", (Object[])new Object[]{DECIMAL_FORMAT.format(numPower)}));
    }
}

