/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.api.IMultiBlock;
import com.github.tartaricacid.touhoulittlemaid.api.LittleMaidAPI;
import com.github.tartaricacid.touhoulittlemaid.capability.CapabilityPowerHandler;
import com.github.tartaricacid.touhoulittlemaid.capability.PowerHandler;
import com.github.tartaricacid.touhoulittlemaid.danmaku.CustomSpellCardEntry;
import com.github.tartaricacid.touhoulittlemaid.danmaku.DanmakuColor;
import com.github.tartaricacid.touhoulittlemaid.danmaku.DanmakuType;
import com.github.tartaricacid.touhoulittlemaid.danmaku.script.EntityLivingBaseWrapper;
import com.github.tartaricacid.touhoulittlemaid.danmaku.script.WorldWrapper;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.EntityDanmaku;
import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemSpellCard;
import com.github.tartaricacid.touhoulittlemaid.proxy.CommonProxy;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.script.Invocable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemHakureiGohei
extends Item {
    private static final Random RANDOM = new Random();
    private double attackDamage;
    private double attackSpeed;

    public ItemHakureiGohei() {
        this.func_77655_b("touhou_little_maid.hakurei_gohei");
        this.func_77625_d(1);
        this.func_77656_e(300);
        this.func_77637_a(MaidItems.MAIN_TABS);
        this.attackDamage = 4.0;
        this.attackSpeed = -2.0;
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        List<IMultiBlock> multiBlockList = LittleMaidAPI.getMultiBlockList();
        IBlockState blockState = worldIn.func_180495_p(pos);
        for (IMultiBlock multiBlock : multiBlockList) {
            Template altarTemplate;
            BlockPos posStart;
            boolean multiBlockIsOkay;
            boolean baseConditionIsOkay = hand == EnumHand.MAIN_HAND;
            boolean bl = multiBlockIsOkay = multiBlock.blockIsSuitable(blockState) && multiBlock.facingIsSuitable(facing);
            if (!baseConditionIsOkay || !multiBlockIsOkay) continue;
            if (!worldIn.field_72995_K && multiBlock.isMatch(worldIn, posStart = pos.func_177971_a((Vec3i)multiBlock.getCenterPos(facing)), facing, altarTemplate = multiBlock.getTemplate(worldIn, facing))) {
                multiBlock.build(worldIn, posStart, facing, altarTemplate);
            }
            return EnumActionResult.SUCCESS;
        }
        return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (!worldIn.field_72995_K && entityLiving instanceof EntityPlayer && !entityLiving.func_70093_af()) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            if (player.func_184592_cb().func_77973_b() == MaidItems.SPELL_CARD) {
                this.spellCardShoot(worldIn, player);
            } else {
                this.normalShoot(stack, worldIn, player, timeLeft);
            }
            worldIn.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187797_fA, player.func_184176_by(), 1.0f, 0.8f);
            stack.func_77972_a(1, (EntityLivingBase)player);
        }
    }

    private void spellCardShoot(World worldIn, EntityPlayer player) {
        try {
            CustomSpellCardEntry entry = ItemSpellCard.getCustomSpellCardEntry(player.func_184592_cb(), CommonProxy.CUSTOM_SPELL_CARD_MAP_SERVER);
            if (entry == null) {
                return;
            }
            Invocable invocable = (Invocable)((Object)CommonProxy.NASHORN);
            invocable.invokeMethod(entry.getScript(), "spellCard", new WorldWrapper(worldIn), new EntityLivingBaseWrapper((EntityLivingBase)player));
            player.func_184811_cZ().func_185145_a((Item)this, entry.getCooldown());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void normalShoot(ItemStack stack, World worldIn, EntityPlayer player, int timeLeft) {
        Vec3d v = player.func_70040_Z();
        PowerHandler powerHandler = (PowerHandler)player.getCapability(CapabilityPowerHandler.POWER_CAP, null);
        int power = powerHandler == null ? 0 : MathHelper.func_76141_d((float)powerHandler.get());
        int a = (500 - timeLeft > 100 ? 100 : 500 - timeLeft) / 20 + power;
        int damage = a + 4;
        float velocity = 0.2f * (float)(a + 1);
        DanmakuColor color = DanmakuColor.getColor(RANDOM.nextInt(DanmakuColor.getLength() + 1));
        DanmakuType type = this.getGoheiMode(stack);
        EntityDanmaku danmaku = new EntityDanmaku(worldIn, (EntityLivingBase)player, damage, 0.0f, type, color);
        danmaku.func_70107_b(danmaku.field_70165_t + v.field_72450_a, danmaku.field_70163_u + v.field_72448_b, danmaku.field_70161_v + v.field_72449_c);
        danmaku.func_70186_c(v.field_72450_a, v.field_72448_b, v.field_72449_c, velocity, 5.0f);
        worldIn.func_72838_d((Entity)danmaku);
        player.func_184811_cZ().func_185145_a((Item)this, 11 - a);
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public ItemStack getDefaultItemStack() {
        ItemStack itemStack = new ItemStack((Item)this);
        this.setGoheiMode(itemStack, DanmakuType.PELLET);
        return itemStack;
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)this.getDefaultItemStack());
        }
    }

    @Nonnull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@Nonnull EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", this.attackDamage, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", this.attackSpeed, 0));
        }
        return multimap;
    }

    public int func_77626_a(ItemStack stack) {
        return 500;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, @Nonnull EnumHand handIn) {
        if (!worldIn.field_72995_K) {
            playerIn.func_184598_c(handIn);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"tooltips.touhou_little_maid.hakurei_gohei.switch_mode.desc", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"tooltips.touhou_little_maid.hakurei_gohei.desc", (Object[])new Object[]{I18n.func_135052_a((String)("danmaku_type.touhou_little_maid." + this.getGoheiMode(stack).name().toLowerCase(Locale.US)), (Object[])new Object[0])}));
    }

    public DanmakuType getGoheiMode(ItemStack stack) {
        return DanmakuType.getType(this.getTagCompoundSafe(stack).func_74762_e(NBT.MODE.getName()));
    }

    public void setGoheiMode(ItemStack stack, DanmakuType mode) {
        this.getTagCompoundSafe(stack).func_74768_a(NBT.MODE.getName(), mode.ordinal());
    }

    private NBTTagCompound getTagCompoundSafe(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            stack.func_77982_d(tagCompound);
        }
        return tagCompound;
    }

    private static enum NBT {
        MODE("GoheiMode");

        private String name;

        private NBT(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

