/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.internal.task;

import com.github.tartaricacid.touhoulittlemaid.api.AbstractEntityMaid;
import com.github.tartaricacid.touhoulittlemaid.api.task.FarmHandler;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class VanillaSugarCaneFarmHandler
implements FarmHandler {
    private static final ResourceLocation NAME = new ResourceLocation("touhou_little_maid", "sugar_cane");

    @Override
    public ResourceLocation getName() {
        return NAME;
    }

    @Override
    public double getMinDistanceSq() {
        return 9.0;
    }

    @Override
    public boolean isSeed(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item == Items.field_151120_aE;
    }

    @Override
    public boolean canHarvest(AbstractEntityMaid maid, World world, BlockPos pos, IBlockState state) {
        Block block = state.func_177230_c();
        return block == Blocks.field_150436_aH && this.canReedHarvest(world.func_180495_p(pos.func_177977_b()).func_177230_c(), world.func_180495_p(pos.func_177979_c(2)).func_177230_c());
    }

    @Override
    public void harvest(AbstractEntityMaid maid, World world, BlockPos pos, IBlockState state) {
        maid.destroyBlock(pos);
    }

    @Override
    public boolean canPlant(AbstractEntityMaid maid, World world, BlockPos pos, ItemStack seed) {
        if (!world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
            return false;
        }
        BlockPos downPos = pos.func_177977_b();
        Block downBlock = world.func_180495_p(downPos).func_177230_c();
        if (downBlock != Blocks.field_150349_c && downBlock != Blocks.field_150346_d && downBlock != Blocks.field_150354_m) {
            return false;
        }
        for (EnumFacing facing : EnumFacing.Plane.HORIZONTAL) {
            IBlockState state = world.func_180495_p(downPos.func_177972_a(facing));
            if (state.func_185904_a() != Material.field_151586_h && state.func_177230_c() != Blocks.field_185778_de) continue;
            return true;
        }
        return false;
    }

    @Override
    public ItemStack plant(AbstractEntityMaid maid, World world, BlockPos pos, ItemStack seed) {
        IBlockState seedState = Blocks.field_150350_a.func_176223_P();
        if (seed.func_77973_b() == Items.field_151120_aE) {
            seedState = Blocks.field_150436_aH.getPlant((IBlockAccess)world, pos);
        }
        if (seedState.func_177230_c() != Blocks.field_150350_a && maid.placeBlock(pos, seedState)) {
            seed.func_190918_g(1);
        }
        return seed;
    }

    private boolean canReedHarvest(Block blockDown, Block blockDown2) {
        boolean blockDownIsOkay = blockDown == Blocks.field_150436_aH;
        boolean blockDown2IsOkay = blockDown2 == Blocks.field_150349_c || blockDown2 == Blocks.field_150346_d || blockDown2 == Blocks.field_150354_m;
        return blockDownIsOkay && blockDown2IsOkay;
    }
}

