/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.internal.task;

import com.github.tartaricacid.touhoulittlemaid.api.AbstractEntityMaid;
import com.github.tartaricacid.touhoulittlemaid.api.task.FarmHandler;
import com.github.tartaricacid.touhoulittlemaid.util.EmptyBlockReader;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public class VanillaNormalFarmHandler
implements FarmHandler {
    private static final ResourceLocation NAME = new ResourceLocation("touhou_little_maid", "farm");

    @Override
    public ResourceLocation getName() {
        return NAME;
    }

    @Override
    public boolean isSeed(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof IPlantable) {
            if (item == Items.field_151075_bm) {
                return true;
            }
            IPlantable plantable = (IPlantable)stack.func_77973_b();
            return plantable.getPlantType((IBlockAccess)EmptyBlockReader.INSTANCE, BlockPos.field_177992_a) == EnumPlantType.Crop && plantable.getPlant((IBlockAccess)EmptyBlockReader.INSTANCE, BlockPos.field_177992_a).func_177230_c() != Blocks.field_150350_a;
        }
        return false;
    }

    @Override
    public boolean canHarvest(AbstractEntityMaid maid, World world, BlockPos pos, IBlockState state) {
        Block block = state.func_177230_c();
        if (block instanceof BlockCrops && ((BlockCrops)block).func_185525_y(state)) {
            return true;
        }
        return block == Blocks.field_150388_bm && (Integer)state.func_177229_b((IProperty)BlockNetherWart.field_176486_a) >= 3;
    }

    @Override
    public void harvest(AbstractEntityMaid maid, World world, BlockPos pos, IBlockState state) {
        maid.destroyBlock(pos);
    }

    @Override
    public boolean canPlant(AbstractEntityMaid maid, World world, BlockPos pos, ItemStack seed) {
        if (!world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
            return false;
        }
        IPlantable plantable = (IPlantable)seed.func_77973_b();
        IBlockState soil = world.func_180495_p(pos.func_177977_b());
        return soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, plantable);
    }

    @Override
    public ItemStack plant(AbstractEntityMaid maid, World world, BlockPos pos, ItemStack seed) {
        IPlantable plantable = (IPlantable)seed.func_77973_b();
        IBlockState seedState = plantable.getPlant((IBlockAccess)world, pos);
        if (seedState.func_177230_c() != Blocks.field_150350_a && maid.placeBlock(pos, seedState)) {
            seed.func_190918_g(1);
        }
        return seed;
    }
}

