/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.internal.task;

import com.github.tartaricacid.touhoulittlemaid.api.AbstractEntityMaid;
import com.github.tartaricacid.touhoulittlemaid.api.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.EntityMaidAttackRanged;
import com.github.tartaricacid.touhoulittlemaid.init.MaidSoundEvent;
import com.github.tartaricacid.touhoulittlemaid.util.ItemFindUtil;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntitySpectralArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TaskAttackRanged
implements IMaidTask {
    public static final ResourceLocation UID = new ResourceLocation("touhou_little_maid", "ranged_attack");

    public static int findArrow(AbstractEntityMaid maid) {
        IItemHandlerModifiable handler = maid.getAvailableInv(true);
        return ItemFindUtil.findStackSlot((IItemHandler)handler, s -> s.func_77973_b() == Items.field_151032_g || s.func_77973_b() == Items.field_185167_i || s.func_77973_b() == Items.field_185166_h);
    }

    @Nullable
    public static EntityArrow getArrow(AbstractEntityMaid maid, float chargeTime) {
        EntitySpectralArrow arrow;
        int slot = TaskAttackRanged.findArrow(maid);
        if (slot < 0) {
            return null;
        }
        IItemHandlerModifiable handler = maid.getAvailableInv(true);
        ItemStack stack = handler.getStackInSlot(slot);
        if (stack.func_77973_b() == Items.field_185166_h) {
            arrow = new EntitySpectralArrow(maid.field_70170_p, (EntityLivingBase)maid);
            arrow.func_190547_a((EntityLivingBase)maid, chargeTime);
        } else {
            arrow = new EntityTippedArrow(maid.field_70170_p, (EntityLivingBase)maid);
            arrow.func_190547_a((EntityLivingBase)maid, chargeTime);
            ((EntityTippedArrow)arrow).func_184555_a(stack);
        }
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)maid.func_184614_ca()) <= 0) {
            stack.func_190918_g(1);
            handler.setStackInSlot(slot, stack);
            arrow.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
        }
        return arrow;
    }

    @Override
    public ResourceLocation getUid() {
        return UID;
    }

    @Override
    public ItemStack getIcon() {
        return new ItemStack((Item)Items.field_151031_f);
    }

    @Override
    public SoundEvent getAmbientSound(AbstractEntityMaid maid) {
        return MaidSoundEvent.MAID_RANGE_ATTACK;
    }

    @Override
    public EntityAIBase createAI(AbstractEntityMaid maid) {
        return new EntityMaidAttackRanged(maid, 0.6f, 2, 16.0f);
    }

    @Override
    public boolean isAttack() {
        return true;
    }

    @Override
    public void onRangedAttack(AbstractEntityMaid maid, EntityLivingBase target, float distanceFactor) {
        EntityArrow entityArrow = TaskAttackRanged.getArrow(maid, distanceFactor);
        if (entityArrow == null) {
            return;
        }
        if (maid.hasSasimono()) {
            boolean targetIsPlayerOwner;
            boolean targetIsTameableHasSameOwner = target instanceof EntityTameable && ((EntityTameable)target).func_184753_b() != null && ((EntityTameable)target).func_184753_b().equals(maid.func_184753_b());
            boolean bl = targetIsPlayerOwner = target instanceof EntityPlayer && target.func_110124_au().equals(maid.func_184753_b());
            if (targetIsTameableHasSameOwner || targetIsPlayerOwner) {
                return;
            }
        }
        double x = target.field_70165_t - maid.field_70165_t;
        double y = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - entityArrow.field_70163_u;
        double z = target.field_70161_v - maid.field_70161_v;
        double pitch = (double)MathHelper.func_76133_a((double)(x * x + z * z)) * 0.15;
        entityArrow.func_70186_c(x, y + pitch, z, 1.6f, 1.0f);
        maid.func_184614_ca().func_77972_a(1, (EntityLivingBase)maid);
        maid.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (maid.func_70681_au().nextFloat() * 0.4f + 0.8f));
        maid.field_70170_p.func_72838_d((Entity)entityArrow);
    }
}

