/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.internal;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.api.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.api.IMultiBlock;
import com.github.tartaricacid.touhoulittlemaid.api.LittleMaidAPI;
import com.github.tartaricacid.touhoulittlemaid.api.task.FarmHandler;
import com.github.tartaricacid.touhoulittlemaid.api.task.FeedHandler;
import com.github.tartaricacid.touhoulittlemaid.api.util.ItemDefinition;
import com.github.tartaricacid.touhoulittlemaid.config.GeneralConfig;
import com.github.tartaricacid.touhoulittlemaid.internal.task.TaskIdle;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

public class LittleMaidAPIImpl
implements LittleMaidAPI.ILittleMaidAPI {
    private final Map<ItemDefinition, IMaidBauble> baubles = Maps.newHashMap();
    private final Map<ResourceLocation, IMaidTask> taskMap = Maps.newHashMap();
    private final List<IMaidTask> tasks = Lists.newArrayList();
    private final List<FarmHandler> farmHandlers = Lists.newArrayList();
    private final List<FeedHandler> feedHandlers = Lists.newArrayList();
    private final List<IMultiBlock> multiBlockList = Lists.newArrayList();
    private IMaidTask IDLE_TASK;

    @Override
    public IMaidBauble registerBauble(ItemDefinition item, IMaidBauble bauble) {
        return this.baubles.put(item, bauble);
    }

    @Override
    public IMaidBauble getBauble(ItemDefinition item) {
        return this.baubles.get(item);
    }

    @Override
    public List<IMaidTask> getTasks() {
        return this.tasks;
    }

    @Override
    public void registerTask(IMaidTask task) {
        this.taskMap.put(task.getUid(), task);
        if (task.getUid().equals((Object)TaskIdle.UID)) {
            this.IDLE_TASK = task;
            if (!this.tasks.isEmpty()) {
                this.tasks.add(0, task);
                return;
            }
        } else {
            Map<String, Boolean> cfg = GeneralConfig.MAID_CONFIG.enabledTasks;
            String uid = task.getUid().toString();
            if (cfg.containsKey(uid)) {
                if (cfg.get(uid).equals(Boolean.FALSE)) {
                    TouhouLittleMaid.LOGGER.info("Disabled task " + uid + ", skipping");
                    return;
                }
            } else {
                cfg.put(uid, Boolean.TRUE);
            }
        }
        this.tasks.add(task);
    }

    @Override
    public Optional<IMaidTask> findTask(ResourceLocation uid) {
        return Optional.fromNullable((Object)this.taskMap.get(uid));
    }

    @Override
    public IMaidTask getIdleTask() {
        return this.IDLE_TASK;
    }

    @Override
    public void registerFarmHandler(FarmHandler handler) {
        this.farmHandlers.add(handler);
    }

    @Override
    public List<FarmHandler> getFarmHandlers() {
        return this.farmHandlers;
    }

    @Override
    public void registerFeedHandler(FeedHandler handler) {
        this.feedHandlers.add(handler);
    }

    @Override
    public List<FeedHandler> getFeedHandlers() {
        return this.feedHandlers;
    }

    @Override
    public void registerMultiBlock(IMultiBlock multiBlock) {
        this.multiBlockList.add(multiBlock);
    }

    @Override
    public List<IMultiBlock> getMultiBlockList() {
        return this.multiBlockList;
    }
}

