/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.event;

import com.github.tartaricacid.touhoulittlemaid.capability.CapabilityOwnerMaidNumHandler;
import com.github.tartaricacid.touhoulittlemaid.capability.CapabilityPowerHandler;
import com.github.tartaricacid.touhoulittlemaid.capability.OwnerMaidNumHandler;
import com.github.tartaricacid.touhoulittlemaid.capability.PowerHandler;
import com.github.tartaricacid.touhoulittlemaid.config.GeneralConfig;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.SyncOwnerMaidNumMessage;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.SyncPowerMessage;
import com.github.tartaricacid.touhoulittlemaid.proxy.CommonProxy;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="touhou_little_maid")
public class PlayerCapabilitiesEvent {
    private static final ResourceLocation POWER_CAP = new ResourceLocation("touhou_little_maid", "power");
    private static final ResourceLocation OWNER_MAID_NUM_CAP = new ResourceLocation("touhou_little_maid", "owner_maid_num");
    private static final ResourceLocation DRAW_CAP = new ResourceLocation("touhou_little_maid", "draw");

    @SubscribeEvent
    public static void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(POWER_CAP, (ICapabilityProvider)new CapabilityPowerHandler());
            event.addCapability(OWNER_MAID_NUM_CAP, (ICapabilityProvider)new CapabilityOwnerMaidNumHandler());
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        EntityPlayer player = event.getEntityPlayer();
        PowerHandler power = (PowerHandler)player.getCapability(CapabilityPowerHandler.POWER_CAP, null);
        PowerHandler oldPower = (PowerHandler)event.getOriginal().getCapability(CapabilityPowerHandler.POWER_CAP, null);
        if (power != null && oldPower != null) {
            if (event.isWasDeath()) {
                power.set(power.get() - (float)GeneralConfig.MISC_CONFIG.playerDeathLossPowerPoint);
            } else {
                power.set(oldPower.get());
            }
        }
        OwnerMaidNumHandler num = (OwnerMaidNumHandler)player.getCapability(CapabilityOwnerMaidNumHandler.OWNER_MAID_NUM_CAP, null);
        OwnerMaidNumHandler oldNum = (OwnerMaidNumHandler)event.getOriginal().getCapability(CapabilityOwnerMaidNumHandler.OWNER_MAID_NUM_CAP, null);
        if (num != null && oldNum != null) {
            num.set(oldNum.get());
        }
    }

    @SubscribeEvent
    public static void playerTickEvent(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        if (event.side == Side.SERVER && event.phase == TickEvent.Phase.END) {
            OwnerMaidNumHandler num;
            PowerHandler power;
            if (player.hasCapability(CapabilityPowerHandler.POWER_CAP, null) && (power = (PowerHandler)player.getCapability(CapabilityPowerHandler.POWER_CAP, null)) != null && power.isDirty()) {
                CommonProxy.INSTANCE.sendTo((IMessage)new SyncPowerMessage(power.get()), (EntityPlayerMP)player);
                power.setDirty(false);
            }
            if (player.hasCapability(CapabilityOwnerMaidNumHandler.OWNER_MAID_NUM_CAP, null) && (num = (OwnerMaidNumHandler)player.getCapability(CapabilityOwnerMaidNumHandler.OWNER_MAID_NUM_CAP, null)) != null && num.isDirty()) {
                CommonProxy.INSTANCE.sendTo((IMessage)new SyncOwnerMaidNumMessage(num.get()), (EntityPlayerMP)player);
                num.setDirty(false);
            }
        }
    }
}

