/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.passive;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.AbstractEntityMaid;
import com.github.tartaricacid.touhoulittlemaid.api.ICanRidingMaid;
import com.github.tartaricacid.touhoulittlemaid.api.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.api.LittleMaidAPI;
import com.github.tartaricacid.touhoulittlemaid.api.MaidInventory;
import com.github.tartaricacid.touhoulittlemaid.api.util.BaubleItemHandler;
import com.github.tartaricacid.touhoulittlemaid.block.BlockGarageKit;
import com.github.tartaricacid.touhoulittlemaid.capability.CapabilityOwnerMaidNumHandler;
import com.github.tartaricacid.touhoulittlemaid.capability.OwnerMaidNumHandler;
import com.github.tartaricacid.touhoulittlemaid.client.model.EntityModelJson;
import com.github.tartaricacid.touhoulittlemaid.config.GeneralConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.EntityMaidAvoidEntity;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.EntityMaidBeg;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.EntityMaidFollowOwner;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.EntityMaidGridInteract;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.EntityMaidOpenDoor;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.EntityMaidPanic;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.EntityMaidPickup;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.EntityMaidReturnHome;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.EntityMaidSit;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.EntityMaidWanderAvoidWater;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.MaidNodeProcessor;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityMarisaBroom;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityPowerPoint;
import com.github.tartaricacid.touhoulittlemaid.entity.monster.EntityFairy;
import com.github.tartaricacid.touhoulittlemaid.entity.monster.EntityRinnosuke;
import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import com.github.tartaricacid.touhoulittlemaid.init.MaidSoundEvent;
import com.github.tartaricacid.touhoulittlemaid.internal.task.TaskIdle;
import com.github.tartaricacid.touhoulittlemaid.inventory.MaidInventoryItemHandler;
import com.github.tartaricacid.touhoulittlemaid.item.ItemKappaCompass;
import com.github.tartaricacid.touhoulittlemaid.network.MaidGuiHandler;
import com.github.tartaricacid.touhoulittlemaid.proxy.ClientProxy;
import com.github.tartaricacid.touhoulittlemaid.proxy.CommonProxy;
import com.github.tartaricacid.touhoulittlemaid.util.ItemDropUtil;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.google.common.base.Predicate;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.ai.EntityFlyHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.EntityArmorInvWrapper;
import net.minecraftforge.items.wrapper.EntityHandsInvWrapper;

public class EntityMaid
extends AbstractEntityMaid {
    public static final Predicate<Entity> IS_PICKUP = entity -> (entity instanceof EntityItem && !MaidInventoryItemHandler.isIllegalItem(((EntityItem)entity).func_92059_d()) || entity instanceof EntityXPOrb || entity instanceof EntityPowerPoint || entity instanceof EntityArrow) && !entity.func_70090_H();
    public static final Predicate<Entity> IS_MOB = entity -> entity instanceof EntityMob && entity.func_70089_S();
    public static final Predicate<Entity> CAN_SHEAR = entity -> entity instanceof IShearable && ((IShearable)entity).isShearable(new ItemStack((Item)Items.field_151097_aZ), (IBlockAccess)entity.field_70170_p, entity.func_180425_c()) && entity.func_70089_S();
    public static final Predicate<Entity> IS_COW = entity -> entity instanceof EntityCow && !((EntityCow)entity).func_70631_g_() && entity.func_70089_S();
    private static final DataParameter<Boolean> BEGGING = EntityDataManager.func_187226_a(EntityMaid.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> PICKUP = EntityDataManager.func_187226_a(EntityMaid.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<String> TASK = EntityDataManager.func_187226_a(EntityMaid.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> EXP = EntityDataManager.func_187226_a(EntityMaid.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<BlockPos> HOME_POS = EntityDataManager.func_187226_a(EntityMaid.class, (DataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Boolean> HOME = EntityDataManager.func_187226_a(EntityMaid.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ARM_RISE = EntityDataManager.func_187226_a(EntityMaid.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<String> MODEL_ID = EntityDataManager.func_187226_a(EntityMaid.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Boolean> STRUCK_BY_LIGHTNING = EntityDataManager.func_187226_a(EntityMaid.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<String> SASIMONO_CRC32 = EntityDataManager.func_187226_a(EntityMaid.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Boolean> SHOW_SASIMONO = EntityDataManager.func_187226_a(EntityMaid.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> INVULNERABLE = EntityDataManager.func_187226_a(EntityMaid.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> BACKPACK_LEVEL = EntityDataManager.func_187226_a(EntityMaid.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final int TASK_PRIORITY = 5;
    private static int pickupSoundCount = GeneralConfig.MAID_CONFIG.maidPickupSoundInterval;
    private static int playerHurtSoundCount = GeneralConfig.MAID_CONFIG.maidHurtSoundInterval;
    private final EntityArmorInvWrapper armorInvWrapper = new EntityArmorInvWrapper((EntityLivingBase)this);
    private final EntityHandsInvWrapper handsInvWrapper = new EntityHandsInvWrapper((EntityLivingBase)this){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return !MaidInventoryItemHandler.isIllegalItem(stack);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (this.isItemValid(slot, stack)) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }
    };
    private final ItemStackHandler mainInv = new MaidInventoryItemHandler(15);
    private final ItemStackHandler smallBackpackInv = new MaidInventoryItemHandler(10);
    private final ItemStackHandler middleBackpackInv = new MaidInventoryItemHandler(10);
    private final ItemStackHandler bigBackpackInv = new MaidInventoryItemHandler(10);
    private final BaubleItemHandler baubleInv = new BaubleItemHandler(8);
    public boolean guiOpening;
    public boolean isDebugFloorOpen = false;
    public boolean isDebugBroomShow = false;
    @Nonnull
    private IMaidTask task = LittleMaidAPI.getIdleTask();
    @Nullable
    private EntityAIBase taskAI;

    public EntityMaid(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.5f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityMaidSit(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityMaidPanic(this, 1.0));
        this.field_70714_bg.func_75776_a(3, new EntityMaidAvoidEntity((EntityCreature)this, EntityRinnosuke.class, 3.0f, 0.8, 0.9));
        this.field_70714_bg.func_75776_a(3, new EntityMaidAvoidEntity((EntityCreature)this, EntityFairy.class, 3.0f, 0.8, 0.9));
        this.field_70714_bg.func_75776_a(3, new EntityMaidAvoidEntity((EntityCreature)this, EntityCreeper.class, 6.0f, 0.8, 0.9));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityMaidReturnHome(this, 0.6f, 200));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityMaidBeg(this, 8.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityMaidGridInteract(this, 0.6f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityMaidOpenDoor(this, true));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityMaidPickup(this, 0.8f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityMaidFollowOwner(this, 0.8f, 5.0f, 2.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 4.0f, 0.1f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityMaid.class, 4.0f, 0.2f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityWolf.class, 4.0f, 0.1f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityOcelot.class, 4.0f, 0.1f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityParrot.class, 4.0f, 0.1f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityMaidWanderAvoidWater(this, 0.4f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityMob.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntitySlime.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BEGGING, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(PICKUP, (Object)Boolean.TRUE);
        this.field_70180_af.func_187214_a(TASK, (Object)TaskIdle.UID.toString());
        this.field_70180_af.func_187214_a(EXP, (Object)0);
        this.field_70180_af.func_187214_a(HOME_POS, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(HOME, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(ARM_RISE, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(MODEL_ID, (Object)"touhou_little_maid:hakurei_reimu");
        this.field_70180_af.func_187214_a(STRUCK_BY_LIGHTNING, (Object)false);
        this.field_70180_af.func_187214_a(SASIMONO_CRC32, (Object)String.valueOf(0L));
        this.field_70180_af.func_187214_a(SHOW_SASIMONO, (Object)false);
        this.field_70180_af.func_187214_a(INVULNERABLE, (Object)false);
        this.field_70180_af.func_187214_a(BACKPACK_LEVEL, (Object)EnumBackPackLevel.EMPTY.getLevel());
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
    }

    public void func_70636_d() {
        this.baubleInv.fireEvent((b, s) -> {
            b.onTick(this, (ItemStack)s);
            return false;
        });
        this.func_82168_bl();
        if (playerHurtSoundCount > 0) {
            --playerHurtSoundCount;
        }
        this.spawnPortalParticle();
        this.randomRestoreHealth();
        super.func_70636_d();
        this.applyEntityRiding();
        this.applyNavigatorAndMoveHelper();
    }

    private void spawnPortalParticle() {
        if (this.field_70170_p.field_72995_K && this.func_190530_aW() && this.func_184753_b() != null) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, new int[0]);
            }
        }
    }

    private void randomRestoreHealth() {
        if (this.func_110143_aJ() < this.func_110138_aP() && (double)this.field_70146_Z.nextFloat() < 0.0025) {
            this.func_70691_i(1.0f);
            this.spawnRestoreHealthParticle(this.field_70146_Z.nextInt(3) + 7);
        }
    }

    private void spawnRestoreHealthParticle(int particleCount) {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < particleCount; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - d0 * 10.0, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O) - d1 * 10.0, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - d2 * 10.0, d0, d1, d2, new int[0]);
            }
        }
    }

    private void applyNavigatorAndMoveHelper() {
        Entity passenger = this.func_184179_bs();
        boolean isRidingBroom = passenger instanceof EntityMarisaBroom;
        boolean isFlyingNavigator = this.field_70699_by instanceof PathNavigateFlying;
        boolean isFlyHelper = this.field_70765_h instanceof EntityFlyHelper;
        if (!(isRidingBroom || isFlyingNavigator || isFlyHelper)) {
            return;
        }
        if (isRidingBroom && isFlyingNavigator && isFlyHelper) {
            return;
        }
        if (isRidingBroom) {
            this.field_70699_by = this.createNavigatorFlying(this.field_70170_p);
            this.field_70765_h = new EntityFlyHelper((EntityLiving)this);
        } else {
            this.field_70699_by = this.createNavigatorGround(this.field_70170_p);
            this.field_70765_h = new EntityMoveHelper((EntityLiving)this);
            this.func_189654_d(false);
        }
    }

    private void applyEntityRiding() {
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ(), entity -> entity instanceof ICanRidingMaid);
        if (list.isEmpty()) {
            return;
        }
        for (Entity entity2 : list) {
            boolean maidNotRiddenAndRiding;
            if (entity2.func_184196_w((Entity)this)) continue;
            boolean bl = maidNotRiddenAndRiding = !entity2.func_184207_aI() && !entity2.func_184218_aH();
            if (this.field_70170_p.field_72995_K || this.func_70906_o() || !maidNotRiddenAndRiding || !(entity2 instanceof ICanRidingMaid) || !((ICanRidingMaid)entity2).canRiding(this)) continue;
            entity2.func_184220_m((Entity)this);
        }
    }

    public void func_184232_k(@Nonnull Entity passenger) {
        if (passenger instanceof ICanRidingMaid) {
            ((ICanRidingMaid)passenger).updatePassenger(this);
        } else {
            super.func_184232_k(passenger);
        }
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    protected void func_85033_bc() {
        List entityList;
        super.func_85033_bc();
        if (this.isPickup() && this.func_70909_n() && !(entityList = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72321_a(0.5, 0.0, 0.5).func_72321_a(-0.5, 0.0, -0.5), IS_PICKUP)).isEmpty() && this.func_70089_S()) {
            for (Entity entityPickup : entityList) {
                if (entityPickup instanceof EntityItem) {
                    this.pickupItem((EntityItem)entityPickup, false);
                }
                if (entityPickup instanceof EntityXPOrb) {
                    this.pickupXPOrb((EntityXPOrb)entityPickup);
                }
                if (entityPickup instanceof EntityPowerPoint) {
                    this.pickupPowerPoint((EntityPowerPoint)entityPickup);
                }
                if (!(entityPickup instanceof EntityArrow)) continue;
                this.pickupArrow((EntityArrow)entityPickup, false);
            }
        }
    }

    public boolean pickupItem(EntityItem entityItem, boolean simulate) {
        if (!this.field_70170_p.field_72995_K && entityItem.func_70089_S() && !entityItem.func_174874_s()) {
            ItemStack itemstack = entityItem.func_92059_d();
            if (MaidInventoryItemHandler.isIllegalItem(itemstack)) {
                return false;
            }
            int count = itemstack.func_190916_E();
            if (count == (itemstack = ItemHandlerHelper.insertItemStacked((IItemHandler)this.getAvailableInv(false), (ItemStack)itemstack, (boolean)simulate)).func_190916_E()) {
                return false;
            }
            if (!simulate) {
                this.func_71001_a((Entity)entityItem, count - itemstack.func_190916_E());
                if (--pickupSoundCount == 0) {
                    this.func_184185_a(MaidSoundEvent.MAID_ITEM_GET, 1.0f, 1.0f);
                    pickupSoundCount = GeneralConfig.MAID_CONFIG.maidPickupSoundInterval;
                }
                if (itemstack.func_190926_b()) {
                    entityItem.func_70106_y();
                } else {
                    entityItem.func_92058_a(itemstack);
                }
            }
            return true;
        }
        return false;
    }

    private void pickupXPOrb(EntityXPOrb entityXPOrb) {
        if (!this.field_70170_p.field_72995_K && entityXPOrb.func_70089_S() && entityXPOrb.field_70532_c == 0) {
            ItemStack itemstack;
            this.func_71001_a((Entity)entityXPOrb, 1);
            if (--pickupSoundCount == 0) {
                this.func_184185_a(MaidSoundEvent.MAID_ITEM_GET, 1.0f, 1.0f);
                pickupSoundCount = GeneralConfig.MAID_CONFIG.maidPickupSoundInterval;
            }
            if (!(itemstack = EnchantmentHelper.func_92099_a((Enchantment)Enchantments.field_185296_A, (EntityLivingBase)this)).func_190926_b() && itemstack.func_77951_h()) {
                int i = Math.min(entityXPOrb.field_70530_e * 2, itemstack.func_77952_i());
                entityXPOrb.field_70530_e -= i / 2;
                itemstack.func_77964_b(itemstack.func_77952_i() - i);
            }
            if (entityXPOrb.field_70530_e > 0) {
                this.addExp(entityXPOrb.field_70530_e);
            }
            entityXPOrb.func_70106_y();
        }
    }

    private void pickupPowerPoint(EntityPowerPoint powerPoint) {
        if (!this.field_70170_p.field_72995_K && powerPoint.func_70089_S() && powerPoint.delayBeforeCanPickup == 0) {
            powerPoint.onPickup((EntityLivingBase)this, 1);
            if (--pickupSoundCount == 0) {
                this.func_184185_a(MaidSoundEvent.MAID_ITEM_GET, 1.0f, 1.0f);
                pickupSoundCount = GeneralConfig.MAID_CONFIG.maidPickupSoundInterval;
            }
            int xpValue = EntityPowerPoint.transPowerValueToXpValue(powerPoint.powerValue);
            ItemStack itemstack = EnchantmentHelper.func_92099_a((Enchantment)Enchantments.field_185296_A, (EntityLivingBase)this);
            if (!itemstack.func_190926_b() && itemstack.func_77951_h()) {
                int i = Math.min(xpValue * 2, itemstack.func_77952_i());
                xpValue -= i / 2;
                itemstack.func_77964_b(itemstack.func_77952_i() - i);
            }
            if (xpValue > 0) {
                this.addExp(xpValue);
            }
            powerPoint.func_70106_y();
        }
    }

    public boolean pickupArrow(EntityArrow arrow, boolean simulate) {
        if (!this.field_70170_p.field_72995_K && arrow.func_70089_S() && arrow.field_70254_i && arrow.field_70249_b <= 0) {
            if (arrow.field_70251_a != EntityArrow.PickupStatus.ALLOWED) {
                return false;
            }
            ItemStack stack = this.getArrowFromEntity(arrow);
            if (!ItemHandlerHelper.insertItemStacked((IItemHandler)this.getAvailableInv(false), (ItemStack)stack, (boolean)simulate).func_190926_b()) {
                return false;
            }
            if (!simulate) {
                this.func_71001_a((Entity)arrow, 1);
                if (--pickupSoundCount == 0) {
                    this.func_184185_a(MaidSoundEvent.MAID_ITEM_GET, 1.0f, 1.0f);
                    pickupSoundCount = GeneralConfig.MAID_CONFIG.maidPickupSoundInterval;
                }
                arrow.func_70106_y();
            }
            return true;
        }
        return false;
    }

    private ItemStack getArrowFromEntity(EntityArrow entity) {
        try {
            Method method = ReflectionHelper.findMethod(entity.getClass(), (String)"getArrowStack", (String)"func_184550_j", (Class[])new Class[0]);
            method.setAccessible(true);
            return (ItemStack)method.invoke(ItemStack.class, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return new ItemStack(Items.field_151032_g);
        }
        catch (ReflectionHelper.UnableToFindMethodException e) {
            return ItemStack.field_190927_a;
        }
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        if (source.func_76346_g() instanceof EntityPlayer && this.func_152114_e((EntityLivingBase)((EntityPlayer)source.func_76346_g())) && this.hasSasimono()) {
            amount = MathHelper.func_76131_a((float)(amount / 5.0f), (float)0.0f, (float)2.0f);
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> cls) {
        return cls != EntityChair.class && cls != EntityMarisaBroom.class && cls != EntityArmorStand.class && super.func_70686_a(cls);
    }

    public void func_82196_d(@Nonnull EntityLivingBase target, float distanceFactor) {
        this.task.onRangedAttack(this, target, distanceFactor);
    }

    public boolean func_70652_k(@Nonnull Entity entityIn) {
        boolean isInvulnerable;
        float damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int knockBack = 0;
        int fireAspect = 0;
        if (entityIn instanceof EntityLivingBase) {
            damage += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            knockBack += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
            fireAspect += EnchantmentHelper.func_90036_a((EntityLivingBase)this);
        }
        if (isInvulnerable = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), damage)) {
            if (knockBack > 0) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)knockBack * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if (fireAspect > 0) {
                entityIn.func_70015_d(fireAspect * 4);
            }
            if (entityIn instanceof EntityPlayer) {
                this.attackEntityAsPlayer((EntityPlayer)entityIn);
            }
            this.func_174815_a((EntityLivingBase)this, entityIn);
            this.func_184614_ca().func_77972_a(1, (EntityLivingBase)this);
        }
        return isInvulnerable;
    }

    private void attackEntityAsPlayer(EntityPlayer entityplayer) {
        ItemStack itemPlayerHand;
        ItemStack itemMaidHand = this.func_184614_ca();
        ItemStack itemStack = itemPlayerHand = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
        if (!itemMaidHand.func_190926_b() && !itemPlayerHand.func_190926_b() && itemMaidHand.func_77973_b().canDisableShield(itemMaidHand, itemPlayerHand, (EntityLivingBase)entityplayer, (EntityLivingBase)this) && itemPlayerHand.func_77973_b().isShield(itemPlayerHand, (EntityLivingBase)entityplayer)) {
            float efficiencyModifier = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
            if (this.field_70146_Z.nextFloat() < efficiencyModifier) {
                entityplayer.func_184811_cZ().func_185145_a(itemPlayerHand.func_77973_b(), 100);
                this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
            }
        }
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        super.func_70077_a(lightningBolt);
        if (!this.isStruckByLightning()) {
            double beforeMaxHealth = this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b();
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(beforeMaxHealth * 2.0);
            this.setStruckByLightning(true);
        }
    }

    protected void func_70675_k(float damage) {
        if ((damage /= 4.0f) < 1.0f) {
            damage = 1.0f;
        }
        for (int i = 0; i < this.armorInvWrapper.getSlots(); ++i) {
            ItemStack itemstack = this.armorInvWrapper.getStackInSlot(i);
            if (!(itemstack.func_77973_b() instanceof ItemArmor)) continue;
            itemstack.func_77972_a((int)damage, (EntityLivingBase)this);
        }
    }

    @Nullable
    public EntityAgeable func_90011_a(@Nonnull EntityAgeable ageable) {
        return null;
    }

    public boolean func_184645_a(EntityPlayer player, @Nullable EnumHand hand) {
        if (hand == EnumHand.MAIN_HAND) {
            boolean isYourMaid = this.func_70909_n() && this.func_184753_b() != null && this.func_184753_b().equals(player.func_110124_au());
            ItemStack itemstack = player.func_184586_b(hand);
            if (isYourMaid) {
                return this.writeHomePos(itemstack, player) || this.applyPotionEffect(itemstack, player) || this.applyGoldenApple(itemstack, player) || this.getExpBottle(itemstack, player) || this.dismountMaid(player) || this.switchSitting(player) || itemstack.func_111282_a(player, (EntityLivingBase)this, EnumHand.MAIN_HAND) || this.openMaidGui(player);
            }
            return this.tamedMaid(itemstack, player);
        }
        return false;
    }

    private boolean tamedMaid(ItemStack itemstack, EntityPlayer player) {
        Item tamedItem = Item.func_111206_d((String)GeneralConfig.MAID_CONFIG.maidTamedItem) == null ? Items.field_151105_aU : Item.func_111206_d((String)GeneralConfig.MAID_CONFIG.maidTamedItem);
        boolean isReloadTamedCondition = itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_189881_dj);
        boolean isNormalTamedCondition = !this.func_70909_n() && itemstack.func_77973_b() == tamedItem;
        boolean isTamedCondition = isReloadTamedCondition || isNormalTamedCondition;
        OwnerMaidNumHandler num = (OwnerMaidNumHandler)player.getCapability(CapabilityOwnerMaidNumHandler.OWNER_MAID_NUM_CAP, null);
        if (!this.field_70170_p.field_72995_K && isTamedCondition && num != null) {
            if (num.canAdd()) {
                this.func_175505_a(player, itemstack);
                this.func_193101_c(player);
                this.func_70908_e(true);
                this.func_70661_as().func_75499_g();
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                this.func_184185_a(MaidSoundEvent.MAID_TAMED, 1.0f, 1.0f);
                num.add();
                return true;
            }
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.touhou_little_maid.owner_maid_num.can_not_add", new Object[]{num.get(), num.getMaxNum()}));
        }
        return false;
    }

    private boolean writeHomePos(ItemStack itemstack, EntityPlayer player) {
        if (itemstack.func_77973_b() == MaidItems.KAPPA_COMPASS) {
            BlockPos pos = ItemKappaCompass.getPos(itemstack);
            if (pos != null) {
                if (player.func_70093_af()) {
                    this.setHomePos(BlockPos.field_177992_a);
                } else {
                    this.setHomePos(pos);
                    if (!this.field_70170_p.field_72995_K) {
                        if (this.func_70906_o() || !this.func_70661_as().func_75492_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, (double)0.6f)) {
                            this.func_184595_k((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                        }
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.touhou_little_maid.kappa_compass.write_success", new Object[0]));
                    }
                }
                return true;
            }
            if (!this.field_70170_p.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.touhou_little_maid.kappa_compass.write_fail", new Object[0]));
            }
        }
        return false;
    }

    private boolean applyPotionEffect(ItemStack itemstack, EntityPlayer player) {
        if (itemstack.func_77973_b() == Items.field_151068_bn) {
            if (player.field_71075_bZ.field_75098_d) {
                itemstack.func_77973_b().func_77654_b(itemstack.func_77946_l(), this.field_70170_p, (EntityLivingBase)this);
            } else {
                player.func_184611_a(EnumHand.MAIN_HAND, itemstack.func_77973_b().func_77654_b(itemstack, this.field_70170_p, (EntityLivingBase)this));
            }
            this.func_184185_a(SoundEvents.field_187664_bz, 0.6f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
            return true;
        }
        return false;
    }

    private boolean applyGoldenApple(ItemStack itemstack, EntityPlayer player) {
        if (itemstack.func_77973_b() == Items.field_151153_ao) {
            if (!this.field_70170_p.field_72995_K) {
                if (itemstack.func_77960_j() > 0) {
                    this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 400, 1));
                    this.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 6000, 0));
                    this.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 6000, 0));
                    this.func_70690_d(new PotionEffect(MobEffects.field_76444_x, 2400, 3));
                } else {
                    this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 100, 1));
                    this.func_70690_d(new PotionEffect(MobEffects.field_76444_x, 2400, 0));
                }
            }
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            this.func_184185_a(SoundEvents.field_187739_dZ, 0.5f, this.field_70146_Z.nextFloat() * 0.1f + 0.9f);
            return true;
        }
        return false;
    }

    private boolean getExpBottle(ItemStack itemstack, EntityPlayer player) {
        int costNum = 12;
        if (itemstack.func_77973_b() == Items.field_151069_bo && this.getExp() / costNum > 0) {
            this.setExp(this.getExp() - costNum);
            itemstack.func_190918_g(1);
            if (!this.field_70170_p.field_72995_K) {
                InventoryHelper.func_180173_a((World)this.field_70170_p, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (ItemStack)new ItemStack(Items.field_151062_by));
            }
            this.func_184185_a(SoundEvents.field_187638_cR, 0.2f, ((this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            return true;
        }
        return false;
    }

    private boolean dismountMaid(EntityPlayer player) {
        if (player.func_70093_af() && (this.func_184187_bx() != null || this.func_184179_bs() != null)) {
            if (this.func_184187_bx() != null) {
                this.func_184210_p();
            }
            if (this.func_184179_bs() != null) {
                this.func_184179_bs().func_184210_p();
            }
            return true;
        }
        return false;
    }

    private boolean switchSitting(EntityPlayer player) {
        if (player.func_70093_af()) {
            this.func_70904_g(!this.func_70906_o());
            if (this.func_70906_o()) {
                this.func_70661_as().func_75499_g();
                this.func_70624_b(null);
                this.func_70604_c(null);
            }
            this.func_184185_a(SoundEvents.field_187638_cR, 0.2f, ((this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            return true;
        }
        return false;
    }

    private boolean openMaidGui(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K) {
            player.openGui((Object)TouhouLittleMaid.INSTANCE, MaidGuiHandler.MAIN_GUI.MAIN.getId(), this.field_70170_p, this.func_145782_y(), LittleMaidAPI.getTasks().indexOf(this.task), 0);
        }
        return true;
    }

    public boolean func_70877_b(ItemStack stack) {
        return false;
    }

    public boolean func_70878_b(@Nonnull EntityAnimal otherAnimal) {
        return false;
    }

    public void func_70645_a(@Nonnull DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70729_aU) {
            return;
        }
        if (this.baubleInv.fireEvent((b, s) -> b.onDropsPre(this, (ItemStack)s))) {
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            IItemHandler itemHandler = (IItemHandler)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            ItemDropUtil.dropItemHandlerItems(itemHandler, this.field_70170_p, this.func_174791_d());
            this.dropGarageKit();
        }
    }

    private void dropGarageKit() {
        this.field_70172_ad = 0;
        this.field_70737_aN = 0;
        this.field_70725_aQ = 0;
        NBTTagCompound entityTag = new NBTTagCompound();
        this.func_70014_b(entityTag);
        entityTag.func_82580_o("ArmorItems");
        entityTag.func_82580_o("HandItems");
        entityTag.func_82580_o(NBT.MAID_INVENTORY.getName());
        entityTag.func_82580_o(NBT.BAUBLE_INVENTORY.getName());
        ItemStack stack = BlockGarageKit.getItemStackWithData("touhou_little_maid:entity.passive.maid", this.getModelId(), entityTag);
        this.func_70099_a(stack, 0.0f).func_184224_h(true);
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
    }

    @Nonnull
    @Deprecated
    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        String modelId = this.getModelId();
        if (this.field_70170_p.field_72995_K) {
            if (ClientProxy.MAID_MODEL.getInfo(modelId).isPresent()) {
                return ParseI18n.parse(ClientProxy.MAID_MODEL.getInfo(modelId).get().getName());
            }
        } else if (CommonProxy.VANILLA_ID_NAME_MAP.containsKey(modelId)) {
            return CommonProxy.VANILLA_ID_NAME_MAP.get(modelId);
        }
        return super.func_70005_c_();
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingData) {
        if (!CommonProxy.VANILLA_ID_NAME_MAP.isEmpty()) {
            String key = (String)CommonProxy.VANILLA_ID_NAME_MAP.keySet().stream().skip(this.field_70146_Z.nextInt(CommonProxy.VANILLA_ID_NAME_MAP.size())).findFirst().get();
            this.setModelId(key);
        }
        return livingData;
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b(NBT.MAID_INVENTORY.getName())) {
            this.mainInv.deserializeNBT((NBTTagCompound)compound.func_74781_a(NBT.MAID_INVENTORY.getName()));
        }
        if (compound.func_74764_b(NBT.BAUBLE_INVENTORY.getName())) {
            this.baubleInv.deserializeNBT((NBTTagCompound)compound.func_74781_a(NBT.BAUBLE_INVENTORY.getName()));
        }
        if (compound.func_74764_b(NBT.IS_PICKUP.getName())) {
            this.setPickup(compound.func_74767_n(NBT.IS_PICKUP.getName()));
        }
        if (compound.func_74764_b(NBT.MAID_TASK.getName())) {
            this.setTask((IMaidTask)LittleMaidAPI.findTask(new ResourceLocation(compound.func_74779_i(NBT.MAID_TASK.getName()))).or((Object)LittleMaidAPI.getIdleTask()));
        }
        if (compound.func_74764_b(NBT.MAID_EXP.getName())) {
            this.setExp(compound.func_74762_e(NBT.MAID_EXP.getName()));
        }
        if (compound.func_74764_b(NBT.HOME_POS.getName())) {
            int[] pos = compound.func_74759_k(NBT.HOME_POS.getName());
            this.setHomePos(new BlockPos(pos[0], pos[1], pos[2]));
        }
        if (compound.func_74764_b(NBT.MAID_HOME.getName())) {
            this.setHome(compound.func_74767_n(NBT.MAID_HOME.getName()));
        }
        if (compound.func_74764_b(NBT.MODEL_ID.getName())) {
            this.setModelId(compound.func_74779_i(NBT.MODEL_ID.getName()));
        }
        if (compound.func_74764_b(NBT.STRUCK_BY_LIGHTNING.getName())) {
            this.setStruckByLightning(compound.func_74767_n(NBT.STRUCK_BY_LIGHTNING.getName()));
        }
        if (compound.func_74764_b(NBT.SASIMONO_CRC32.getName())) {
            this.setSasimonoCRC32(compound.func_74763_f(NBT.SASIMONO_CRC32.getName()));
        }
        if (compound.func_74764_b(NBT.SHOW_SASIMONO.getName())) {
            this.setShowSasimono(compound.func_74767_n(NBT.SHOW_SASIMONO.getName()));
        }
        if (compound.func_74764_b(NBT.INVULNERABLE.getName())) {
            this.func_184224_h(compound.func_74767_n(NBT.INVULNERABLE.getName()));
        }
        if (compound.func_74764_b(NBT.BACKPACK_LEVEL.getName())) {
            this.setBackpackLevel(EnumBackPackLevel.getEnumLevelByNum(compound.func_74762_e(NBT.BACKPACK_LEVEL.getName())));
        }
        if (compound.func_74764_b(NBT.MAID_SMALL_BACKPACK.getName())) {
            this.smallBackpackInv.deserializeNBT((NBTTagCompound)compound.func_74781_a(NBT.MAID_SMALL_BACKPACK.getName()));
        }
        if (compound.func_74764_b(NBT.MAID_MIDDLE_BACKPACK.getName())) {
            this.middleBackpackInv.deserializeNBT((NBTTagCompound)compound.func_74781_a(NBT.MAID_MIDDLE_BACKPACK.getName()));
        }
        if (compound.func_74764_b(NBT.MAID_BIG_BACKPACK.getName())) {
            this.bigBackpackInv.deserializeNBT((NBTTagCompound)compound.func_74781_a(NBT.MAID_BIG_BACKPACK.getName()));
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74782_a(NBT.MAID_INVENTORY.getName(), (NBTBase)this.mainInv.serializeNBT());
        compound.func_74782_a(NBT.BAUBLE_INVENTORY.getName(), (NBTBase)this.baubleInv.serializeNBT());
        compound.func_74757_a(NBT.IS_PICKUP.getName(), this.isPickup());
        compound.func_74778_a(NBT.MAID_TASK.getName(), this.task.getUid().toString());
        compound.func_74768_a(NBT.MAID_EXP.getName(), this.getExp());
        compound.func_74783_a(NBT.HOME_POS.getName(), new int[]{this.getHomePos().func_177958_n(), this.getHomePos().func_177956_o(), this.getHomePos().func_177952_p()});
        compound.func_74757_a(NBT.MAID_HOME.getName(), this.isHome());
        compound.func_74778_a(NBT.MODEL_ID.getName(), this.getModelId());
        compound.func_74757_a(NBT.STRUCK_BY_LIGHTNING.getName(), this.isStruckByLightning());
        compound.func_74772_a(NBT.SASIMONO_CRC32.getName(), this.getSasimonoCRC32().longValue());
        compound.func_74757_a(NBT.SHOW_SASIMONO.getName(), this.isShowSasimono());
        compound.func_74757_a(NBT.INVULNERABLE.getName(), this.func_190530_aW());
        compound.func_74768_a(NBT.BACKPACK_LEVEL.getName(), this.getBackLevel().getLevel());
        compound.func_74782_a(NBT.MAID_SMALL_BACKPACK.getName(), (NBTBase)this.smallBackpackInv.serializeNBT());
        compound.func_74782_a(NBT.MAID_MIDDLE_BACKPACK.getName(), (NBTBase)this.middleBackpackInv.serializeNBT());
        compound.func_74782_a(NBT.MAID_BIG_BACKPACK.getName(), (NBTBase)this.bigBackpackInv.serializeNBT());
    }

    public boolean func_190530_aW() {
        return (Boolean)this.field_70180_af.func_187225_a(INVULNERABLE);
    }

    public void func_184224_h(boolean isInvulnerable) {
        super.func_184224_h(isInvulnerable);
        this.field_70180_af.func_187227_b(INVULNERABLE, (Object)isInvulnerable);
    }

    public int func_70627_aG() {
        return GeneralConfig.MAID_CONFIG.maidTalkInterval;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return this.task.getAmbientSound(this);
    }

    protected float func_70647_i() {
        return 1.0f + this.field_70146_Z.nextFloat() * 0.1f;
    }

    public boolean func_70631_g_() {
        return false;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        if (damageSourceIn.func_76347_k()) {
            return MaidSoundEvent.MAID_HURT_FIRE;
        }
        if (damageSourceIn.func_76346_g() instanceof EntityPlayer) {
            if (playerHurtSoundCount == 0) {
                playerHurtSoundCount = GeneralConfig.MAID_CONFIG.maidHurtSoundInterval;
                return MaidSoundEvent.MAID_PLAYER;
            }
            return null;
        }
        return MaidSoundEvent.MAID_HURT;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return MaidSoundEvent.MAID_DEATH;
    }

    public float func_70047_e() {
        return this.field_70131_O * (this.func_70906_o() ? 0.65f : 0.85f);
    }

    @Nonnull
    protected PathNavigate func_175447_b(@Nonnull World worldIn) {
        if (this.func_184179_bs() instanceof EntityMarisaBroom) {
            return this.createNavigatorFlying(worldIn);
        }
        return this.createNavigatorGround(worldIn);
    }

    private PathNavigate createNavigatorFlying(World worldIn) {
        PathNavigateFlying pathnavigateflying = new PathNavigateFlying((EntityLiving)this, worldIn);
        pathnavigateflying.func_192877_c(true);
        pathnavigateflying.func_192878_b(true);
        pathnavigateflying.func_192879_a(true);
        pathnavigateflying.func_75489_a((double)0.8f);
        return pathnavigateflying;
    }

    private PathNavigate createNavigatorGround(World worldIn) {
        PathNavigateGround pathNavigate = new PathNavigateGround((EntityLiving)this, worldIn){

            protected PathFinder func_179679_a() {
                this.field_179695_a = new MaidNodeProcessor();
                this.field_179695_a.func_186317_a(true);
                return new PathFinder(this.field_179695_a);
            }
        };
        pathNavigate.func_179688_b(true);
        pathNavigate.func_179691_c(true);
        pathNavigate.func_179693_d(true);
        pathNavigate.func_179685_e(false);
        return pathNavigate;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            switch (this.getBackLevel()) {
                default: {
                    return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new CombinedInvWrapper(new IItemHandlerModifiable[]{this.armorInvWrapper, this.handsInvWrapper, this.mainInv, this.baubleInv}));
                }
                case SMALL: {
                    return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new CombinedInvWrapper(new IItemHandlerModifiable[]{this.armorInvWrapper, this.handsInvWrapper, this.mainInv, this.smallBackpackInv, this.baubleInv}));
                }
                case MIDDLE: {
                    return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new CombinedInvWrapper(new IItemHandlerModifiable[]{this.armorInvWrapper, this.handsInvWrapper, this.mainInv, this.smallBackpackInv, this.middleBackpackInv, this.baubleInv}));
                }
                case BIG: 
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new CombinedInvWrapper(new IItemHandlerModifiable[]{this.armorInvWrapper, this.handsInvWrapper, this.mainInv, this.smallBackpackInv, this.middleBackpackInv, this.bigBackpackInv, this.baubleInv}));
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public IItemHandlerModifiable getInv(MaidInventory type) {
        switch (type) {
            case MAIN: {
                return this.mainInv;
            }
            case HAND: {
                return this.handsInvWrapper;
            }
            case BAUBLE: {
                return this.baubleInv;
            }
            case ARMOR: {
                return this.armorInvWrapper;
            }
            case SMALL_BACKPACK: {
                return this.smallBackpackInv;
            }
            case MIDDLE_BACKPACK: {
                return this.middleBackpackInv;
            }
            case BIG_BACKPACK: {
                return this.bigBackpackInv;
            }
        }
        return this.mainInv;
    }

    public IItemHandlerModifiable getAllBackpackInv() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.smallBackpackInv, this.middleBackpackInv, this.bigBackpackInv});
    }

    @Nullable
    public EntityLivingBase func_70638_az() {
        boolean hasSasimonoAndTargetIsTameable;
        boolean hasSasimonoAndTargetIsPlayer = this.hasSasimono() && super.func_70638_az() instanceof EntityPlayer;
        boolean bl = hasSasimonoAndTargetIsTameable = this.hasSasimono() && super.func_70638_az() instanceof EntityTameable;
        if (hasSasimonoAndTargetIsPlayer || hasSasimonoAndTargetIsTameable) {
            return null;
        }
        return super.func_70638_az();
    }

    public void func_70624_b(@Nullable EntityLivingBase entityLivingBase) {
        boolean hasSasimonoAndTargetIsTameable;
        boolean hasSasimonoAndTargetIsPlayer = this.hasSasimono() && entityLivingBase instanceof EntityPlayer;
        boolean bl = hasSasimonoAndTargetIsTameable = this.hasSasimono() && entityLivingBase instanceof EntityTameable;
        if (hasSasimonoAndTargetIsPlayer || hasSasimonoAndTargetIsTameable) {
            super.func_70624_b(null);
        } else {
            super.func_70624_b(entityLivingBase);
        }
    }

    @Nullable
    public EntityLivingBase func_70643_av() {
        boolean hasSasimonoAndTargetIsTameable;
        boolean hasSasimonoAndTargetIsPlayer = this.hasSasimono() && super.func_70643_av() instanceof EntityPlayer;
        boolean bl = hasSasimonoAndTargetIsTameable = this.hasSasimono() && super.func_70643_av() instanceof EntityTameable;
        if (hasSasimonoAndTargetIsPlayer || hasSasimonoAndTargetIsTameable) {
            return null;
        }
        return super.func_70643_av();
    }

    public void func_70604_c(@Nullable EntityLivingBase entityLivingBase) {
        boolean hasSasimonoAndTargetIsTameable;
        boolean hasSasimonoAndTargetIsPlayer = this.hasSasimono() && entityLivingBase instanceof EntityPlayer;
        boolean bl = hasSasimonoAndTargetIsTameable = this.hasSasimono() && entityLivingBase instanceof EntityTameable;
        if (hasSasimonoAndTargetIsPlayer || hasSasimonoAndTargetIsTameable) {
            super.func_70604_c(null);
        } else {
            super.func_70604_c(entityLivingBase);
        }
    }

    @Override
    public BaubleItemHandler getBaubleInv() {
        return this.baubleInv;
    }

    public CombinedInvWrapper getAvailableInv(boolean handsFirst) {
        CombinedInvWrapper combinedInvWrapper;
        switch (this.getBackLevel()) {
            default: {
                combinedInvWrapper = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.mainInv});
                break;
            }
            case SMALL: {
                combinedInvWrapper = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.mainInv, this.smallBackpackInv});
                break;
            }
            case MIDDLE: {
                combinedInvWrapper = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.mainInv, this.smallBackpackInv, this.middleBackpackInv});
                break;
            }
            case BIG: {
                combinedInvWrapper = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.mainInv, this.smallBackpackInv, this.middleBackpackInv, this.bigBackpackInv});
            }
        }
        return handsFirst ? new CombinedInvWrapper(new IItemHandlerModifiable[]{this.handsInvWrapper, combinedInvWrapper}) : new CombinedInvWrapper(new IItemHandlerModifiable[]{combinedInvWrapper, this.handsInvWrapper});
    }

    public boolean isBegging() {
        return (Boolean)this.field_70180_af.func_187225_a(BEGGING);
    }

    public void setBegging(boolean beg) {
        this.field_70180_af.func_187227_b(BEGGING, (Object)beg);
    }

    @Override
    public boolean isPickup() {
        return (Boolean)this.field_70180_af.func_187225_a(PICKUP);
    }

    public void setPickup(boolean pickup) {
        this.field_70180_af.func_187227_b(PICKUP, (Object)pickup);
    }

    public IMaidTask getTask() {
        return (IMaidTask)LittleMaidAPI.findTask(new ResourceLocation((String)this.field_70180_af.func_187225_a(TASK))).or((Object)LittleMaidAPI.getIdleTask());
    }

    public void setTask(IMaidTask task) {
        if (task == this.task) {
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.taskAI != null) {
                this.field_70714_bg.func_85156_a(this.taskAI);
            }
            this.taskAI = task.createAI(this);
            if (this.taskAI != null) {
                this.field_70714_bg.func_75776_a(5, this.taskAI);
            }
        }
        this.task = task;
        this.field_70180_af.func_187227_b(TASK, (Object)task.getUid().toString());
    }

    public int getExp() {
        return (Integer)this.field_70180_af.func_187225_a(EXP);
    }

    public void setExp(int expIn) {
        this.field_70180_af.func_187227_b(EXP, (Object)expIn);
    }

    public void addExp(int expIn) {
        this.setExp(this.getExp() + expIn);
    }

    public BlockPos getHomePos() {
        return (BlockPos)this.field_70180_af.func_187225_a(HOME_POS);
    }

    public void setHomePos(BlockPos home) {
        this.field_70180_af.func_187227_b(HOME_POS, (Object)home);
    }

    @Override
    public boolean isHome() {
        return (Boolean)this.field_70180_af.func_187225_a(HOME);
    }

    public void setHome(boolean isHome) {
        this.field_70180_af.func_187227_b(HOME, (Object)isHome);
    }

    public boolean isSwingingArms() {
        return (Boolean)this.field_70180_af.func_187225_a(ARM_RISE);
    }

    public void func_184724_a(boolean swingingArms) {
        this.field_70180_af.func_187227_b(ARM_RISE, (Object)swingingArms);
    }

    @Override
    public String getModelId() {
        return (String)this.field_70180_af.func_187225_a(MODEL_ID);
    }

    @Override
    public void setModelId(String modelId) {
        this.field_70180_af.func_187227_b(MODEL_ID, (Object)modelId);
    }

    public boolean isStruckByLightning() {
        return (Boolean)this.func_184212_Q().func_187225_a(STRUCK_BY_LIGHTNING);
    }

    public void setStruckByLightning(boolean isStruck) {
        this.func_184212_Q().func_187227_b(STRUCK_BY_LIGHTNING, (Object)isStruck);
    }

    public Long getSasimonoCRC32() {
        return Long.valueOf((String)this.field_70180_af.func_187225_a(SASIMONO_CRC32));
    }

    public void setSasimonoCRC32(Long crc32) {
        this.field_70180_af.func_187227_b(SASIMONO_CRC32, (Object)String.valueOf(crc32));
    }

    @Override
    public boolean hasSasimono() {
        return !((String)this.field_70180_af.func_187225_a(SASIMONO_CRC32)).equals(String.valueOf(0L));
    }

    public boolean isShowSasimono() {
        return (Boolean)this.field_70180_af.func_187225_a(SHOW_SASIMONO);
    }

    public void setShowSasimono(boolean isShow) {
        this.field_70180_af.func_187227_b(SHOW_SASIMONO, (Object)isShow);
    }

    public void setBackpackLevel(EnumBackPackLevel level) {
        this.field_70180_af.func_187227_b(BACKPACK_LEVEL, (Object)MathHelper.func_76125_a((int)level.getLevel(), (int)EnumBackPackLevel.EMPTY.getLevel(), (int)EnumBackPackLevel.BIG.getLevel()));
    }

    public EnumBackPackLevel getBackLevel() {
        return EnumBackPackLevel.getEnumLevelByNum((Integer)this.field_70180_af.func_187225_a(BACKPACK_LEVEL));
    }

    @Override
    public boolean canDestroyBlock(BlockPos pos) {
        IBlockState state = this.field_70170_p.func_180495_p(pos);
        return state.func_177230_c().canEntityDestroy(state, (IBlockAccess)this.field_70170_p, pos, (Entity)this) && ForgeEventFactory.onEntityDestroyBlock((EntityLivingBase)this, (BlockPos)pos, (IBlockState)state);
    }

    @Override
    public boolean canPlaceBlock(BlockPos pos, IBlockState state) {
        IBlockState oldState = this.field_70170_p.func_180495_p(pos);
        return oldState.func_177230_c().func_176200_f((IBlockAccess)this.field_70170_p, pos);
    }

    @Override
    public boolean destroyBlock(BlockPos pos) {
        return this.destroyBlock(pos, true);
    }

    @Override
    public boolean destroyBlock(BlockPos pos, boolean dropBlock) {
        return this.canDestroyBlock(pos) && this.field_70170_p.func_175655_b(pos, dropBlock);
    }

    @Override
    public boolean placeBlock(BlockPos pos, IBlockState state) {
        return this.canPlaceBlock(pos, state) && this.field_70170_p.func_175656_a(pos, state);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        EntityModelJson modelJson = ClientProxy.MAID_MODEL.getModel(this.getModelId()).orElse(null);
        if (modelJson == null) {
            return super.func_184177_bl();
        }
        return modelJson.renderBoundingBox.func_191194_a(this.func_174791_d());
    }

    public static enum EnumBackPackLevel {
        EMPTY(0),
        SMALL(1),
        MIDDLE(2),
        BIG(3);

        private int level;

        private EnumBackPackLevel(int level) {
            this.level = level;
        }

        public static EnumBackPackLevel getEnumLevelByNum(int num) {
            int numClamp = MathHelper.func_76125_a((int)num, (int)EMPTY.getLevel(), (int)BIG.getLevel());
            return EnumBackPackLevel.values()[numClamp];
        }

        public int getLevel() {
            return this.level;
        }
    }

    public static enum NBT {
        MAID_INVENTORY("MaidInventory"),
        BAUBLE_INVENTORY("BaubleInventory"),
        IS_PICKUP("IsPickup"),
        MAID_TASK("MaidTask"),
        MAID_EXP("MaidExp"),
        HOME_POS("HomePos"),
        MAID_HOME("MaidHome"),
        MODEL_ID("ModelId"),
        STRUCK_BY_LIGHTNING("StruckByLightning"),
        SASIMONO_CRC32("SasimonoCRC32"),
        SHOW_SASIMONO("ShowSasimono"),
        INVULNERABLE("Invulnerable"),
        BACKPACK_LEVEL("BackpackLevel"),
        MAID_SMALL_BACKPACK("MaidSmallBackpack"),
        MAID_MIDDLE_BACKPACK("MaidMiddleBackpack"),
        MAID_BIG_BACKPACK("MaidBigBackpack");

        private String name;

        private NBT(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

