/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.monster;

import com.github.tartaricacid.touhoulittlemaid.config.GeneralConfig;
import com.github.tartaricacid.touhoulittlemaid.danmaku.DanmakuColor;
import com.github.tartaricacid.touhoulittlemaid.danmaku.DanmakuShoot;
import com.github.tartaricacid.touhoulittlemaid.danmaku.DanmakuType;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.EntityFairyAttack;
import com.github.tartaricacid.touhoulittlemaid.entity.monster.AbstractEntityTouhouMob;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityFlyHelper;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.passive.EntityFlying;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityFairy
extends AbstractEntityTouhouMob
implements IRangedAttackMob,
EntityFlying {
    private static final String FAIRY_TYPE_TAG_NAME = "FairyType";
    private static final DataParameter<Integer> FAIRY_TYPE = EntityDataManager.func_187226_a(EntityFairy.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityFairy(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.5f);
        this.field_70765_h = new EntityFlyHelper((EntityLiving)this);
    }

    @Override
    public int getPowerPoint() {
        return (int)(GeneralConfig.MOB_CONFIG.maidFairyPowerPoint * 100.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityFairyAttack(this, 6.0, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityMaid.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityMaid.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityIronGolem.class, true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FAIRY_TYPE, (Object)TYPE.BLACK_MAID_FAIRY.ordinal());
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.5);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111128_a(0.4);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, @Nonnull IBlockState state, @Nonnull BlockPos pos) {
    }

    @Nonnull
    protected PathNavigate func_175447_b(@Nonnull World worldIn) {
        PathNavigateFlying pathnavigateflying = new PathNavigateFlying((EntityLiving)this, worldIn);
        pathnavigateflying.func_192879_a(false);
        pathnavigateflying.func_192877_c(true);
        pathnavigateflying.func_192878_b(true);
        return pathnavigateflying;
    }

    public void func_82196_d(@Nonnull EntityLivingBase target, float distanceFactor) {
        if (this.field_70146_Z.nextFloat() <= 0.9f) {
            DanmakuShoot.aimedShot(this.field_70170_p, (EntityLivingBase)this, target, distanceFactor + 1.0f, 0.0f, Float.valueOf(0.2f * (distanceFactor + 1.0f)), Float.valueOf(0.2f), DanmakuType.getType(this.field_70146_Z.nextInt(2)), DanmakuColor.getColor(this.field_70146_Z.nextInt(7)));
        } else {
            DanmakuShoot.fanShapedShot(this.field_70170_p, (EntityLivingBase)this, target, distanceFactor + 1.5f, 0.0f, Float.valueOf(0.2f * (distanceFactor + 1.0f)), Float.valueOf(0.2f), DanmakuType.getType(this.field_70146_Z.nextInt(2)), DanmakuColor.getColor(this.field_70146_Z.nextInt(7)), 0.5235987755982988, 3);
        }
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingData) {
        this.setFairyTypeOrdinal(this.field_70146_Z.nextInt(3));
        return super.func_180482_a(difficulty, livingData);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a(FAIRY_TYPE_TAG_NAME, this.getFairyTypeOrdinal());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b(FAIRY_TYPE_TAG_NAME)) {
            this.setFairyTypeOrdinal(compound.func_74762_e(FAIRY_TYPE_TAG_NAME));
        }
    }

    public void func_184724_a(boolean swingingArms) {
    }

    public int getFairyTypeOrdinal() {
        return (Integer)this.field_70180_af.func_187225_a(FAIRY_TYPE);
    }

    public void setFairyTypeOrdinal(int ordinal) {
        this.field_70180_af.func_187227_b(FAIRY_TYPE, (Object)ordinal);
    }

    static enum TYPE {
        BLACK_MAID_FAIRY,
        ORANGE_MAID_FAIRY,
        WHITE_MAID_FAIRY;

    }
}

