/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.item;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.AbstractEntityMaid;
import com.github.tartaricacid.touhoulittlemaid.api.ICanRidingMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import com.github.tartaricacid.touhoulittlemaid.network.MaidGuiHandler;
import com.github.tartaricacid.touhoulittlemaid.util.ItemDropUtil;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class EntitySuitcase
extends EntityLivingBase
implements ICanRidingMaid {
    private static final String MAIN_INV_TAG = "MainInventory";
    private final ItemStackHandler mainInv = new ItemStackHandler(27);

    public EntitySuitcase(World worldIn) {
        super(worldIn);
        this.field_70156_m = true;
        this.func_70105_a(0.8f, 0.8f);
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (player.func_184586_b(hand).func_111282_a(player, (EntityLivingBase)this, hand)) {
            return true;
        }
        player.openGui((Object)TouhouLittleMaid.INSTANCE, MaidGuiHandler.OTHER_GUI.SUITCASE.getId(), this.field_70170_p, this.func_145782_y(), 0, 0);
        return true;
    }

    @Override
    public void updatePassenger(AbstractEntityMaid maid) {
        if (maid.func_184196_w((Entity)this)) {
            this.field_70759_as = maid.field_70759_as;
            this.field_70125_A = maid.field_70125_A;
            this.field_70177_z = maid.field_70177_z;
            this.field_70761_aq = maid.field_70761_aq;
            Vec3d vec3d = maid.func_174791_d().func_178787_e(new Vec3d(0.4, 0.0, -1.0).func_178785_b(maid.field_70761_aq * ((float)(-Math.PI) / 180)));
            this.func_70107_b(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
        }
    }

    public void func_110145_l(Entity entityIn) {
        if (!(entityIn instanceof EntityMaid)) {
            super.func_110145_l(entityIn);
        }
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            if (this.func_180431_b(source)) {
                return false;
            }
            if (source.func_76346_g() instanceof EntityPlayer) {
                return this.applyHitSuitcaseLogic((EntityPlayer)source.func_76346_g());
            }
        }
        return false;
    }

    private boolean applyHitSuitcaseLogic(EntityPlayer player) {
        boolean isPlayerCreativeMode = player.field_71075_bZ.field_75098_d;
        if (player.func_70093_af()) {
            this.func_184226_ay();
            this.func_184185_a(SoundEvents.field_187546_ae, 1.0f, 1.0f);
            if (isPlayerCreativeMode && !this.func_145818_k_()) {
                this.func_70106_y();
            } else {
                this.killSuitcase();
            }
            IItemHandler itemHandler = (IItemHandler)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            ItemDropUtil.dropItemHandlerItems(itemHandler, this.field_70170_p, this.func_174791_d());
        }
        return true;
    }

    private void killSuitcase() {
        this.func_70106_y();
        if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
            ItemStack itemstack = new ItemStack(MaidItems.SUITCASE, 1);
            if (this.func_145818_k_()) {
                itemstack.func_151001_c(this.func_95999_t());
            }
            this.func_70099_a(itemstack, 0.0f);
        }
    }

    @Nonnull
    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(MaidItems.SUITCASE);
    }

    public boolean func_190631_cK() {
        return false;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74782_a(MAIN_INV_TAG, (NBTBase)this.mainInv.serializeNBT());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b(MAIN_INV_TAG, 10)) {
            this.mainInv.deserializeNBT(compound.func_74775_l(MAIN_INV_TAG));
        }
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.mainInv);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Nonnull
    public ItemStack func_184582_a(@Nonnull EntityEquipmentSlot slotIn) {
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(@Nonnull EntityEquipmentSlot slotIn, @Nonnull ItemStack stack) {
    }

    @Nonnull
    public Iterable<ItemStack> func_184193_aE() {
        return Collections.emptyList();
    }

    @Nonnull
    public EnumHandSide func_184591_cq() {
        return EnumHandSide.LEFT;
    }
}

