/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.item;

import com.github.tartaricacid.touhoulittlemaid.capability.CapabilityPowerHandler;
import com.github.tartaricacid.touhoulittlemaid.capability.PowerHandler;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.BeaconAbsorbMessage;
import com.github.tartaricacid.touhoulittlemaid.proxy.CommonProxy;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketCollectItem;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityPowerPoint
extends Entity {
    public int delayBeforeCanPickup;
    public int powerValue;
    private int powerColor;
    private int powerAge;
    private int powerHealthy = 5;
    private EntityPlayer closestPlayer;
    private int powerTargetColor;

    public EntityPowerPoint(World worldIn, double x, double y, double z, int powerValue) {
        super(worldIn);
        this.func_70105_a(0.5f, 0.5f);
        this.func_70107_b(x, y, z);
        this.field_70177_z = (float)(Math.random() * 360.0);
        this.field_70159_w = (Math.random() * 0.2 - 0.1) * 2.0;
        this.field_70181_x = Math.random() * 0.2 * 2.0;
        this.field_70179_y = (Math.random() * 0.2 - 0.1) * 2.0;
        this.powerValue = powerValue;
    }

    public EntityPowerPoint(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.25f, 0.25f);
    }

    public static int getPowerSplit(int expValue) {
        if (expValue >= 485) {
            return 485;
        }
        if (expValue >= 385) {
            return 385;
        }
        if (expValue >= 285) {
            return 285;
        }
        if (expValue >= 185) {
            return 185;
        }
        if (expValue >= 89) {
            return 89;
        }
        if (expValue >= 36) {
            return 34;
        }
        if (expValue >= 17) {
            return 13;
        }
        if (expValue >= 7) {
            return 7;
        }
        if (expValue >= 5) {
            return 5;
        }
        return expValue >= 3 ? 3 : 1;
    }

    public static int transPowerValueToXpValue(int powerValue) {
        return powerValue / 4;
    }

    public static void spawnExplosionParticle(World world, float x, float y, float z, Random rand) {
        if (!world.field_72995_K) {
            return;
        }
        for (int i = 0; i < 20; ++i) {
            float mx = (rand.nextFloat() - 0.5f) * 0.02f;
            float my = (rand.nextFloat() - 0.5f) * 0.02f;
            float mz = (rand.nextFloat() - 0.5f) * 0.02f;
            world.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, (double)(x + rand.nextFloat() - 0.5f), (double)(y + rand.nextFloat() - 0.5f), (double)(z + rand.nextFloat() - 0.5f), (double)mx, (double)my, (double)mz, new int[0]);
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        float f = 0.5f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        int i = super.func_70070_b();
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public void func_70071_h_() {
        double distanceZ;
        double distanceY;
        double distanceX;
        double distanceSqrt;
        double negativeDistanceSqrt;
        super.func_70071_h_();
        if (this.delayBeforeCanPickup > 0) {
            --this.delayBeforeCanPickup;
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (!this.func_189652_ae()) {
            this.field_70181_x -= 0.03;
        }
        if (this.field_70170_p.func_180495_p(new BlockPos((Entity)this)).func_185904_a() == Material.field_151587_i) {
            this.field_70181_x = 0.2;
            this.field_70159_w = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f;
            this.field_70179_y = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f;
            this.func_184185_a(SoundEvents.field_187658_bx, 0.4f, 2.0f + this.field_70146_Z.nextFloat() * 0.4f);
        }
        this.func_145771_j(this.field_70165_t, (this.func_174813_aQ().field_72338_b + this.func_174813_aQ().field_72337_e) / 2.0, this.field_70161_v);
        double distance = 8.0;
        if (this.powerTargetColor < this.powerColor - 20 + this.func_145782_y() % 100) {
            if (this.closestPlayer == null || this.closestPlayer.func_70068_e((Entity)this) > Math.sqrt(distance)) {
                this.closestPlayer = this.field_70170_p.func_72890_a((Entity)this, distance);
            }
            this.powerTargetColor = this.powerColor;
        }
        if (this.closestPlayer != null && this.closestPlayer.func_175149_v()) {
            this.closestPlayer = null;
        }
        if (this.closestPlayer != null && (negativeDistanceSqrt = 1.0 - (distanceSqrt = Math.sqrt((distanceX = (this.closestPlayer.field_70165_t - this.field_70165_t) / 8.0) * distanceX + (distanceY = (this.closestPlayer.field_70163_u + (double)this.closestPlayer.func_70047_e() / 2.0 - this.field_70163_u) / 8.0) * distanceY + (distanceZ = (this.closestPlayer.field_70161_v - this.field_70161_v) / 8.0) * distanceZ))) > 0.0) {
            negativeDistanceSqrt *= negativeDistanceSqrt;
            double coefficient = this.closestPlayer.func_70093_af() ? 3.0 : 0.1;
            this.field_70159_w += distanceX / distanceSqrt * negativeDistanceSqrt * coefficient;
            this.field_70181_x += distanceY / distanceSqrt * negativeDistanceSqrt * coefficient;
            this.field_70179_y += distanceZ / distanceSqrt * negativeDistanceSqrt * coefficient;
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        float slipperiness = 0.98f;
        if (this.field_70122_E) {
            BlockPos underPos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
            IBlockState underState = this.field_70170_p.func_180495_p(underPos);
            slipperiness = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)this.field_70170_p, underPos, (Entity)this) * 0.98f;
        }
        this.field_70159_w *= (double)slipperiness;
        this.field_70181_x *= 0.98;
        this.field_70179_y *= (double)slipperiness;
        if (this.field_70122_E) {
            this.field_70181_x *= -0.9;
        }
        ++this.powerColor;
        ++this.powerAge;
        int maxAge = 6000;
        if (this.powerAge >= maxAge) {
            this.func_70106_y();
        }
    }

    public boolean func_70072_I() {
        return this.field_70170_p.func_72918_a(this.func_174813_aQ(), Material.field_151586_h, (Entity)this);
    }

    protected void func_70081_e(int amount) {
        this.func_70097_a(DamageSource.field_76372_a, amount);
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return false;
        }
        if (this.func_180431_b(source)) {
            return false;
        }
        this.func_70018_K();
        this.powerHealthy = (int)((float)this.powerHealthy - amount);
        if (this.powerHealthy <= 0) {
            this.func_70106_y();
        }
        return false;
    }

    public void func_70014_b(@Nonnull NBTTagCompound compound) {
        compound.func_74777_a("Health", (short)this.powerHealthy);
        compound.func_74777_a("Age", (short)this.powerAge);
        compound.func_74777_a("Value", (short)this.powerValue);
    }

    public void func_70037_a(@Nonnull NBTTagCompound compound) {
        this.powerHealthy = compound.func_74765_d("Health");
        this.powerAge = compound.func_74765_d("Age");
        this.powerValue = compound.func_74765_d("Value");
    }

    public boolean func_70075_an() {
        return false;
    }

    public void func_70100_b_(@Nonnull EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K) {
            PowerHandler power = (PowerHandler)player.getCapability(CapabilityPowerHandler.POWER_CAP, null);
            if (this.delayBeforeCanPickup == 0 && player.field_71090_bL == 0 && power != null) {
                player.field_71090_bL = 2;
                this.onPickup((EntityLivingBase)player, 1);
                if (this.powerValue > 0) {
                    if (power.get() + (float)this.powerValue / 100.0f > 5.0f) {
                        power.add(5.0f - power.get());
                        int residualValue = this.powerValue - 500 + (int)(power.get() * 100.0f);
                        player.func_71023_q(EntityPowerPoint.transPowerValueToXpValue(residualValue));
                    } else {
                        power.add((float)this.powerValue / 100.0f);
                    }
                }
                this.func_70106_y();
            }
        }
    }

    public void onPickup(EntityLivingBase base, int quantity) {
        if (!this.field_70128_L && !this.field_70170_p.field_72995_K) {
            EntityTracker entitytracker = ((WorldServer)this.field_70170_p).func_73039_n();
            entitytracker.func_151247_a((Entity)this, (Packet)new SPacketCollectItem(this.func_145782_y(), base.func_145782_y(), quantity));
        }
    }

    public void spawnExplosionParticle() {
        float x = (float)this.field_70165_t;
        float y = (float)this.field_70163_u + 0.125f;
        float z = (float)this.field_70161_v;
        if (this.field_70170_p.field_72995_K) {
            EntityPowerPoint.spawnExplosionParticle(this.field_70170_p, x, y, z, this.field_70146_Z);
        } else {
            CommonProxy.INSTANCE.sendToAllAround((IMessage)new BeaconAbsorbMessage(x, y, z), new NetworkRegistry.TargetPoint(this.field_71093_bK, (double)x, (double)y, (double)z, 16.0));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getTextureByXP() {
        if (this.powerValue >= 485) {
            return 10;
        }
        if (this.powerValue >= 385) {
            return 9;
        }
        if (this.powerValue >= 285) {
            return 8;
        }
        if (this.powerValue >= 185) {
            return 7;
        }
        if (this.powerValue >= 89) {
            return 6;
        }
        if (this.powerValue >= 36) {
            return 5;
        }
        if (this.powerValue >= 17) {
            return 4;
        }
        if (this.powerValue >= 7) {
            return 3;
        }
        if (this.powerValue >= 5) {
            return 2;
        }
        return this.powerValue >= 3 ? 1 : 0;
    }
}

