/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.item;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.model.EntityModelJson;
import com.github.tartaricacid.touhoulittlemaid.config.GeneralConfig;
import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemChair;
import com.github.tartaricacid.touhoulittlemaid.network.MaidGuiHandler;
import com.github.tartaricacid.touhoulittlemaid.proxy.ClientProxy;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityChair
extends EntityLivingBase {
    private static final DataParameter<String> MODEL_ID = EntityDataManager.func_187226_a(EntityChair.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Float> MOUNTED_HEIGHT = EntityDataManager.func_187226_a(EntityChair.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> TAMEABLE_CAN_RIDE = EntityDataManager.func_187226_a(EntityChair.class, (DataSerializer)DataSerializers.field_187198_h);
    public boolean isDebugFloorOpen = false;
    public boolean isDebugCharacterOpen = false;

    public EntityChair(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.875f, 0.5f);
    }

    public EntityChair(World worldIn, double x, double y, double z, float yaw) {
        this(worldIn);
        this.func_70012_b(x, y, z, yaw, 0.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MODEL_ID, (Object)"touhou_little_maid:cushion");
        this.field_70180_af.func_187214_a(MOUNTED_HEIGHT, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(TAMEABLE_CAN_RIDE, (Object)true);
    }

    protected void func_85033_bc() {
        super.func_85033_bc();
        List list = this.field_70170_p.func_72872_a(EntityTameable.class, this.func_174813_aQ().func_72321_a(0.0, 0.5, 0.0));
        if (list.isEmpty()) {
            return;
        }
        for (Entity entity : list) {
            boolean notRiddenAndRiding;
            if (entity.func_184196_w((Entity)this)) continue;
            boolean bl = notRiddenAndRiding = !entity.func_184207_aI() && !entity.func_184218_aH();
            if (this.field_70170_p.field_72995_K || !notRiddenAndRiding || !(entity instanceof EntityTameable) || !this.isTameableCanRide()) continue;
            if (((EntityTameable)entity).func_70906_o()) {
                return;
            }
            entity.func_184220_m((Entity)this);
        }
    }

    @Nonnull
    public ItemStack getPickedResult(RayTraceResult target) {
        return ItemChair.setAllTagData(new ItemStack(MaidItems.CHAIR), this.getModelId(), this.getMountedHeight(), this.isTameableCanRide(), this.func_189652_ae());
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_82167_n(Entity entityIn) {
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            if (player.func_184586_b(hand).func_111282_a(player, (EntityLivingBase)this, hand)) {
                return true;
            }
            if (this.field_70170_p.field_72995_K) {
                player.openGui((Object)TouhouLittleMaid.INSTANCE, MaidGuiHandler.OTHER_GUI.CHAIR.getId(), this.field_70170_p, this.func_145782_y(), 0, 0);
            }
            return true;
        }
        if (!(this.field_70170_p.field_72995_K || this.func_184207_aI() || player.func_184218_aH())) {
            player.func_184220_m((Entity)this);
        }
        return true;
    }

    public void func_184232_k(@Nonnull Entity passenger) {
        super.func_184232_k(passenger);
        if (this.func_184196_w(passenger) && passenger instanceof EntityLivingBase) {
            this.field_70761_aq = ((EntityLivingBase)passenger).field_70761_aq;
        }
    }

    @Nonnull
    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        if (this.field_70170_p.field_72995_K && ClientProxy.CHAIR_MODEL.getInfo(this.getModelId()).isPresent()) {
            String name = ClientProxy.CHAIR_MODEL.getInfo(this.getModelId()).get().getName();
            return ParseI18n.parse(name);
        }
        return super.func_70005_c_();
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        EntityModelJson modelJson = ClientProxy.CHAIR_MODEL.getModel(this.getModelId()).orElse(null);
        if (modelJson == null) {
            return super.func_184177_bl();
        }
        return modelJson.renderBoundingBox.func_191194_a(this.func_174791_d());
    }

    public double func_70042_X() {
        return this.getMountedHeight();
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_190631_cK() {
        return false;
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            if (this.func_180431_b(source)) {
                return false;
            }
            if (source.func_76346_g() instanceof EntityPlayer) {
                return this.applyHitChairLogic((EntityPlayer)source.func_76346_g());
            }
        }
        return false;
    }

    private boolean applyHitChairLogic(EntityPlayer player) {
        boolean isPlayerCreativeMode = player.field_71075_bZ.field_75098_d;
        if (player.func_70093_af()) {
            this.func_184226_ay();
            this.func_184185_a(SoundEvents.field_187546_ae, 1.0f, 1.0f);
            if (isPlayerCreativeMode && !this.func_145818_k_()) {
                this.func_70106_y();
            } else if (!GeneralConfig.MISC_CONFIG.chairCannotBeDestroied || isPlayerCreativeMode) {
                this.killChair();
            }
        }
        return true;
    }

    private void killChair() {
        this.func_70106_y();
        if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
            ItemStack itemstack = new ItemStack(MaidItems.CHAIR, 1);
            ItemChair.setAllTagData(itemstack, this.getModelId(), this.getMountedHeight(), this.isTameableCanRide(), this.func_189652_ae());
            if (this.func_145818_k_()) {
                itemstack.func_151001_c(this.func_95999_t());
            }
            this.func_70099_a(itemstack, 0.0f);
        }
    }

    public void func_70037_a(@Nonnull NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b(NBT.MODEL_ID.getName())) {
            this.setModelId(compound.func_74779_i(NBT.MODEL_ID.getName()));
        }
        if (compound.func_74764_b(NBT.MOUNTED_HEIGHT.getName())) {
            this.setMountedHeight(compound.func_74760_g(NBT.MOUNTED_HEIGHT.getName()));
        }
        if (compound.func_74764_b(NBT.TAMEABLE_CAN_RIDE.getName())) {
            this.setTameableCanRide(compound.func_74767_n(NBT.TAMEABLE_CAN_RIDE.getName()));
        }
    }

    public void func_70014_b(@Nonnull NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74778_a(NBT.MODEL_ID.getName(), this.getModelId());
        compound.func_74776_a(NBT.MOUNTED_HEIGHT.getName(), this.getMountedHeight());
        compound.func_74757_a(NBT.TAMEABLE_CAN_RIDE.getName(), this.isTameableCanRide());
    }

    public String getModelId() {
        return (String)this.field_70180_af.func_187225_a(MODEL_ID);
    }

    public void setModelId(String modelId) {
        this.field_70180_af.func_187227_b(MODEL_ID, (Object)modelId);
    }

    public float getMountedHeight() {
        return ((Float)this.field_70180_af.func_187225_a(MOUNTED_HEIGHT)).floatValue();
    }

    public void setMountedHeight(float height) {
        height = MathHelper.func_76131_a((float)height, (float)-0.5f, (float)2.5f);
        this.field_70180_af.func_187227_b(MOUNTED_HEIGHT, (Object)Float.valueOf(height));
    }

    public boolean isTameableCanRide() {
        return (Boolean)this.field_70180_af.func_187225_a(TAMEABLE_CAN_RIDE);
    }

    public void setTameableCanRide(boolean canRide) {
        this.field_70180_af.func_187227_b(TAMEABLE_CAN_RIDE, (Object)canRide);
    }

    @Nonnull
    public ItemStack func_184582_a(@Nonnull EntityEquipmentSlot slotIn) {
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(@Nonnull EntityEquipmentSlot slotIn, @Nonnull ItemStack stack) {
    }

    @Nonnull
    public Iterable<ItemStack> func_184193_aE() {
        return Collections.emptyList();
    }

    @Nonnull
    public EnumHandSide func_184591_cq() {
        return EnumHandSide.LEFT;
    }

    static enum NBT {
        MODEL_ID("ModelId"),
        MOUNTED_HEIGHT("MountedHeight"),
        TAMEABLE_CAN_RIDE("TameableCanRide");

        private String name;

        private NBT(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

