/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.item;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import com.github.tartaricacid.touhoulittlemaid.util.ItemDropUtil;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class EntityBackpack
extends Entity {
    private static final String INV_TAG_NAME = "BackpackInv";
    private static final String LEVEL_TAG_NAME = "BackpackLevel";
    private final ItemStackHandler inv = new ItemStackHandler(30);
    private static final DataParameter<Integer> BACKPACK_LEVEL = EntityDataManager.func_187226_a(EntityBackpack.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityBackpack(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 1.2f);
    }

    public EntityBackpack(World worldIn, EntityMaid.EnumBackPackLevel backPackLevel) {
        super(worldIn);
        this.setBackpackLevel(backPackLevel);
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            if (this.func_180431_b(source)) {
                return false;
            }
            if (source.func_76346_g() instanceof EntityPlayer) {
                return this.applyHitBackpackLogic((EntityPlayer)source.func_76346_g());
            }
        }
        return false;
    }

    private boolean applyHitBackpackLogic(EntityPlayer player) {
        boolean isPlayerCreativeMode = player.field_71075_bZ.field_75098_d;
        if (player.func_70093_af()) {
            this.func_184185_a(SoundEvents.field_187546_ae, 1.0f, 1.0f);
            if (isPlayerCreativeMode) {
                this.func_70106_y();
            } else {
                this.killBackpack();
            }
            ItemDropUtil.dropItemHandlerItems((IItemHandler)this.getInv(), this.field_70170_p, this.func_174791_d());
        }
        return true;
    }

    private void killBackpack() {
        this.func_70106_y();
        if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
            for (int i = 1; i <= this.getBackpackLevel().getLevel(); ++i) {
                ItemStack itemstack = new ItemStack(MaidItems.MAID_BACKPACK, 1, i);
                this.func_70099_a(itemstack, 0.0f);
            }
        }
    }

    public ItemStackHandler getInv() {
        return this.inv;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(BACKPACK_LEVEL, (Object)EntityMaid.EnumBackPackLevel.SMALL.getLevel());
    }

    protected void func_70037_a(@Nonnull NBTTagCompound compound) {
        if (compound.func_150297_b(INV_TAG_NAME, 10)) {
            this.inv.deserializeNBT(compound.func_74775_l(INV_TAG_NAME));
        }
        if (compound.func_150297_b(LEVEL_TAG_NAME, 3)) {
            this.setBackpackLevel(compound.func_74762_e(LEVEL_TAG_NAME));
        }
    }

    protected void func_70014_b(@Nonnull NBTTagCompound compound) {
        compound.func_74782_a(INV_TAG_NAME, (NBTBase)this.inv.serializeNBT());
        compound.func_74768_a(LEVEL_TAG_NAME, this.getBackpackLevel().getLevel());
    }

    public EntityMaid.EnumBackPackLevel getBackpackLevel() {
        return EntityMaid.EnumBackPackLevel.getEnumLevelByNum((Integer)this.field_70180_af.func_187225_a(BACKPACK_LEVEL));
    }

    public void setBackpackLevel(EntityMaid.EnumBackPackLevel level) {
        this.setBackpackLevel(level.getLevel());
    }

    private void setBackpackLevel(int level) {
        this.field_70180_af.func_187227_b(BACKPACK_LEVEL, (Object)level);
    }
}

