/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.compat.mcmp.MCMPCompat;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.MaidBlocks;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityGrid;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIMoveToBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandlerModifiable;

public class EntityMaidGridInteract
extends EntityAIMoveToBlock {
    private final EntityMaid maid;
    private TASK currentTask;

    public EntityMaidGridInteract(EntityMaid entityMaid, double speedIn) {
        super((EntityCreature)entityMaid, speedIn, 16);
        this.maid = entityMaid;
    }

    public boolean func_75250_a() {
        if (this.maid.guiOpening || this.maid.func_70906_o()) {
            return false;
        }
        if (--this.field_179496_a > 0) {
            return false;
        }
        this.field_179496_a = 50 + this.maid.func_70681_au().nextInt(50);
        this.currentTask = TASK.NONE;
        return this.func_179489_g();
    }

    public boolean func_75253_b() {
        return !this.maid.guiOpening && this.currentTask != TASK.NONE && !this.maid.func_70906_o() && super.func_75253_b();
    }

    public void func_75246_d() {
        this.tryMoveToDestination(2.25, 40);
        if (this.func_179487_f()) {
            World world = this.maid.field_70170_p;
            BlockPos pos = this.field_179494_b.func_177984_a();
            if (this.currentTask == TASK.MOVING) {
                IBlockState state = world.func_180495_p(pos);
                for (TileEntityGrid grid : this.getTilesIn(world, pos, state)) {
                    if (grid.interact((IItemHandlerModifiable)this.maid.getAvailableInv(false), this.maid, false)) break;
                }
            }
            this.currentTask = TASK.NONE;
        }
        this.maid.func_70671_ap().func_75650_a((double)this.field_179494_b.func_177958_n() + 0.5, (double)(this.field_179494_b.func_177956_o() + 1), (double)this.field_179494_b.func_177952_p() + 0.5, 10.0f, (float)this.maid.func_70646_bf());
    }

    protected boolean func_179488_a(World worldIn, BlockPos pos) {
        IBlockState stateUp2 = worldIn.func_180495_p((pos = pos.func_177984_a()).func_177984_a());
        if (!stateUp2.func_177230_c().func_176205_b((IBlockAccess)worldIn, pos.func_177984_a())) {
            return false;
        }
        IBlockState stateUp = worldIn.func_180495_p(pos);
        for (TileEntityGrid grid : this.getTilesIn(worldIn, pos, stateUp)) {
            if (grid.updateMode(null) == TileEntityGrid.Mode.UNKNOWN || !grid.interact((IItemHandlerModifiable)this.maid.getAvailableInv(false), this.maid, true)) continue;
            this.currentTask = TASK.MOVING;
            return true;
        }
        return false;
    }

    private List<TileEntityGrid> getTilesIn(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tile;
        ArrayList grids = Lists.newArrayList();
        if (TouhouLittleMaid.MCMPCompat) {
            MCMPCompat.getPartTiles(worldIn, pos, state, grids);
        }
        if (state.func_177230_c() == MaidBlocks.GRID && (tile = worldIn.func_175625_s(pos)) instanceof TileEntityGrid) {
            grids.add((TileEntityGrid)tile);
        }
        return grids;
    }

    private void tryMoveToDestination(double minDistanceSq, int interval) {
        if (this.maid.func_174831_c(this.field_179494_b.func_177984_a()) > Math.sqrt(minDistanceSq)) {
            this.field_179491_g = false;
            ++this.field_179493_e;
            if (this.field_179493_e % interval == 0) {
                this.maid.func_70661_as().func_75492_a((double)this.field_179494_b.func_177958_n() + 0.5, (double)(this.field_179494_b.func_177956_o() + 1), (double)this.field_179494_b.func_177952_p() + 0.5, this.field_179492_d);
            }
        } else {
            this.field_179491_g = true;
            --this.field_179493_e;
        }
    }

    private static enum TASK {
        MOVING,
        NONE;

    }
}

