/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai;

import com.github.tartaricacid.touhoulittlemaid.api.AbstractEntityMaid;
import com.github.tartaricacid.touhoulittlemaid.api.LittleMaidAPI;
import com.github.tartaricacid.touhoulittlemaid.api.task.FeedHandler;
import com.github.tartaricacid.touhoulittlemaid.api.task.Trend;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.items.IItemHandlerModifiable;

public class EntityMaidFeedOwner
extends EntityAIBase {
    private AbstractEntityMaid entityMaid;
    private int timeCount;
    private int distance;

    public EntityMaidFeedOwner(AbstractEntityMaid entityMaid, int distance) {
        this.entityMaid = entityMaid;
        this.timeCount = 60;
        this.distance = distance;
    }

    public boolean func_75250_a() {
        --this.timeCount;
        boolean ownerIsOkay = this.entityMaid.func_70902_q() instanceof EntityPlayer && this.entityMaid.func_70032_d((Entity)this.entityMaid.func_70902_q()) < (float)this.distance;
        return this.timeCount < 0 && !this.entityMaid.func_70906_o() && ownerIsOkay;
    }

    public void func_75249_e() {
        this.timeCount = 60;
        if (this.entityMaid.func_70902_q() instanceof EntityPlayer && this.entityMaid.func_70902_q().func_70089_S()) {
            EntityPlayer player = (EntityPlayer)this.entityMaid.func_70902_q();
            boolean dying = player.func_110143_aJ() / player.func_110138_aP() < 0.5f;
            List handlers = LittleMaidAPI.getFeedHandlers().stream().filter(h -> h.canExecute(this.entityMaid)).collect(Collectors.toList());
            Int2ObjectArrayMap goodFoods = new Int2ObjectArrayMap();
            Int2ObjectArrayMap badFoods = new Int2ObjectArrayMap();
            Int2ObjectArrayMap exactFoods = new Int2ObjectArrayMap();
            IItemHandlerModifiable inv = this.entityMaid.getAvailableInv(true);
            block0: for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack stack = inv.getStackInSlot(i);
                for (FeedHandler handler : handlers) {
                    if (!handler.isFood(stack, player)) continue;
                    Trend trend = handler.getTrend(stack, player);
                    if (trend == Trend.EXACT) {
                        exactFoods.put(i, (Object)handler);
                        continue block0;
                    }
                    if (trend == Trend.BAD) {
                        badFoods.put(i, (Object)handler);
                        continue block0;
                    }
                    if (!dying || trend != Trend.GOOD) continue;
                    goodFoods.put(i, (Object)handler);
                    continue block0;
                }
            }
            if (exactFoods.isEmpty() && badFoods.isEmpty() && goodFoods.isEmpty()) {
                return;
            }
            Int2ObjectArrayMap map = !exactFoods.isEmpty() ? exactFoods : (!badFoods.isEmpty() ? badFoods : goodFoods);
            int slot = (Integer)map.keySet().stream().skip(this.entityMaid.func_70681_au().nextInt(map.size())).findFirst().get();
            FeedHandler handler = (FeedHandler)map.get(slot);
            this.entityMaid.func_70671_ap().func_75651_a((Entity)player, 10.0f, 40.0f);
            inv.setStackInSlot(slot, handler.feed(inv.getStackInSlot(slot), player));
            this.entityMaid.func_184609_a(EnumHand.MAIN_HAND);
            this.timeCount = 5;
        }
    }

    public boolean func_75253_b() {
        return false;
    }
}

