/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai;

import com.github.tartaricacid.touhoulittlemaid.api.AbstractEntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import com.github.tartaricacid.touhoulittlemaid.internal.task.TaskAttackRanged;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.item.ItemBow;
import net.minecraft.util.EnumHand;

public class EntityMaidAttackRanged
extends EntityAIBase {
    private final AbstractEntityMaid entity;
    private final double moveSpeedAmp;
    private final float maxAttackDistance;
    private int attackCooldown;
    private int attackTime = -1;
    private int seeTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;

    public EntityMaidAttackRanged(AbstractEntityMaid entity, double moveSpeedAmpIn, int attackCooldownIn, float maxAttackDistanceIn) {
        this.entity = entity;
        this.moveSpeedAmp = moveSpeedAmpIn;
        this.attackCooldown = attackCooldownIn;
        this.maxAttackDistance = maxAttackDistanceIn * maxAttackDistanceIn;
        this.func_75248_a(3);
    }

    public void setAttackCooldown(int cooldown) {
        this.attackCooldown = cooldown;
    }

    public boolean func_75250_a() {
        boolean canRangeAttack = this.isBowInMainhand() && TaskAttackRanged.findArrow(this.entity) >= 0;
        boolean canDanmakuAttack = this.isGoheiInMainhand();
        boolean canAttack = this.entity.func_70638_az() != null && this.entity.func_70638_az().func_70089_S() && (canRangeAttack || canDanmakuAttack);
        return !this.entity.func_70906_o() && canAttack;
    }

    private boolean isBowInMainhand() {
        return this.entity.func_184614_ca().func_77973_b() instanceof ItemBow;
    }

    private boolean isGoheiInMainhand() {
        return this.entity.func_184614_ca().func_77973_b() == MaidItems.HAKUREI_GOHEI;
    }

    public boolean func_75253_b() {
        return this.func_75250_a();
    }

    public void func_75249_e() {
        this.entity.func_184724_a(true);
    }

    public void func_75251_c() {
        this.seeTime = 0;
        this.attackTime = -1;
        this.entity.func_184602_cy();
        this.entity.func_184724_a(false);
        this.entity.func_70661_as().func_75499_g();
    }

    public void func_75246_d() {
        EntityLivingBase entitylivingbase = this.entity.func_70638_az();
        if (entitylivingbase != null) {
            boolean seeTimeMoreThanZero;
            double distanceSq = this.entity.func_70092_e(entitylivingbase.field_70165_t, entitylivingbase.func_174813_aQ().field_72338_b, entitylivingbase.field_70161_v);
            boolean canSee = this.entity.func_70635_at().func_75522_a((Entity)entitylivingbase);
            boolean bl = seeTimeMoreThanZero = this.seeTime > 0;
            if (canSee != seeTimeMoreThanZero) {
                this.seeTime = 0;
            }
            this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
            if (distanceSq <= (double)this.maxAttackDistance && this.seeTime >= 20) {
                this.entity.func_70661_as().func_75499_g();
                ++this.strafingTime;
            } else {
                this.entity.func_70661_as().func_75497_a((Entity)entitylivingbase, this.moveSpeedAmp);
                this.strafingTime = -1;
            }
            if (this.strafingTime >= 20) {
                if ((double)this.entity.func_70681_au().nextFloat() < 0.3) {
                    boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)this.entity.func_70681_au().nextFloat() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (distanceSq > (double)(this.maxAttackDistance * 0.75f)) {
                    this.strafingBackwards = false;
                } else if (distanceSq < (double)(this.maxAttackDistance * 0.25f)) {
                    this.strafingBackwards = true;
                }
                this.entity.func_70605_aq().func_188488_a(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                this.entity.func_70625_a((Entity)entitylivingbase, 30.0f, 30.0f);
            } else {
                this.entity.func_70671_ap().func_75651_a((Entity)entitylivingbase, 30.0f, 30.0f);
            }
            if (this.entity.func_184587_cr()) {
                int i;
                if (!canSee && this.seeTime < -60) {
                    this.entity.func_184602_cy();
                } else if (canSee && (i = this.entity.func_184612_cw()) >= 20) {
                    this.entity.func_184602_cy();
                    this.entity.func_82196_d(entitylivingbase, ItemBow.func_185059_b((int)i));
                    this.attackTime = this.attackCooldown;
                }
            } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
                this.entity.func_184598_c(EnumHand.MAIN_HAND);
            }
        }
    }
}

