/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.danmaku;

import com.github.tartaricacid.touhoulittlemaid.danmaku.DanmakuColor;
import com.github.tartaricacid.touhoulittlemaid.danmaku.DanmakuType;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.EntityDanmaku;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public final class DanmakuShoot {
    private static Random RANDOM = new Random();

    public static void aimedShot(World worldIn, EntityLivingBase thrower, EntityLivingBase target, float damage, float gravity, Float velocity, Float inaccuracy, DanmakuType type, DanmakuColor color) {
        if (!worldIn.field_72995_K) {
            EntityDanmaku danmaku = new EntityDanmaku(worldIn, thrower, damage, gravity, type, color);
            float offset = 0.3f / target.field_70131_O;
            danmaku.func_70186_c(target.field_70165_t - thrower.field_70165_t, target.field_70163_u - thrower.field_70163_u - (double)offset, target.field_70161_v - thrower.field_70161_v, velocity.floatValue(), inaccuracy.floatValue());
            worldIn.func_72838_d((Entity)danmaku);
        }
        worldIn.func_184148_a(null, thrower.field_70165_t, thrower.field_70163_u, thrower.field_70161_v, SoundEvents.field_187797_fA, thrower.func_184176_by(), 1.0f, 0.8f);
    }

    public static void fanShapedShot(World worldIn, EntityLivingBase thrower, EntityLivingBase target, float damage, float gravity, Float velocity, Float inaccuracy, DanmakuType type, DanmakuColor color, double yawTotal, int fanNum) {
        if (yawTotal < 0.0 || yawTotal > Math.PI * 2 || fanNum < 2) {
            return;
        }
        if (!worldIn.field_72995_K) {
            float offset = 0.3f / target.field_70131_O;
            Vec3d v = new Vec3d(target.field_70165_t - thrower.field_70165_t, target.field_70163_u - thrower.field_70163_u - (double)offset, target.field_70161_v - thrower.field_70161_v);
            double yaw = -(yawTotal / 2.0);
            double addYaw = yawTotal / (double)(fanNum - 1);
            for (int i = 1; i <= fanNum; ++i) {
                Vec3d v1 = v.func_178785_b((float)yaw);
                yaw += addYaw;
                EntityDanmaku danmaku = new EntityDanmaku(worldIn, thrower, damage, gravity, type, color);
                danmaku.func_70186_c(v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, velocity.floatValue(), inaccuracy.floatValue());
                worldIn.func_72838_d((Entity)danmaku);
            }
        }
        worldIn.func_184148_a(null, thrower.field_70165_t, thrower.field_70163_u, thrower.field_70161_v, SoundEvents.field_187797_fA, thrower.func_184176_by(), 1.0f, 0.8f);
    }
}

