/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.crafting;

import com.github.tartaricacid.touhoulittlemaid.api.util.ItemDefinition;
import com.github.tartaricacid.touhoulittlemaid.api.util.OreDictDefinition;
import com.github.tartaricacid.touhoulittlemaid.api.util.ProcessingInput;
import com.github.tartaricacid.touhoulittlemaid.crafting.AltarRecipe;
import com.github.tartaricacid.touhoulittlemaid.crafting.ReviveMaidAltarRecipe;
import com.github.tartaricacid.touhoulittlemaid.crafting.SpawnMaidRecipe;
import com.github.tartaricacid.touhoulittlemaid.init.MaidBlocks;
import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemHakureiGohei;
import com.github.tartaricacid.touhoulittlemaid.proxy.CommonProxy;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class AltarRecipesManager {
    private final Map<ResourceLocation, AltarRecipe> ALTAR_RECIPES_MAP = Maps.newHashMap();

    public AltarRecipesManager() {
        OreDictDefinition blockGold = OreDictDefinition.of("blockGold");
        OreDictDefinition blockIron = OreDictDefinition.of("blockIron");
        OreDictDefinition blockLapis = OreDictDefinition.of("blockLapis");
        OreDictDefinition blockCoal = OreDictDefinition.of("blockCoal");
        OreDictDefinition gunpowder = OreDictDefinition.of("gunpowder");
        ItemDefinition blazePowder = ItemDefinition.of(Items.field_151065_br);
        OreDictDefinition paper = OreDictDefinition.of("paper");
        OreDictDefinition stick = OreDictDefinition.of("stickWood");
        OreDictDefinition obsidian = OreDictDefinition.of("obsidian");
        OreDictDefinition redstone = OreDictDefinition.of("dustRedstone");
        OreDictDefinition blockRedstone = OreDictDefinition.of("blockRedstone");
        OreDictDefinition quartzBlock = OreDictDefinition.of("blockQuartz");
        OreDictDefinition dyeCyan = OreDictDefinition.of("dyeCyan");
        OreDictDefinition dyeOrange = OreDictDefinition.of("dyeOrange");
        OreDictDefinition dyeRed = OreDictDefinition.of("dyeRed");
        OreDictDefinition dyeBlue = OreDictDefinition.of("dyeBlue");
        OreDictDefinition dyeYellow = OreDictDefinition.of("dyeYellow");
        OreDictDefinition dyeLime = OreDictDefinition.of("dyeLime");
        ItemDefinition shield = ItemDefinition.of(Items.field_185159_cQ);
        ItemDefinition sugar = ItemDefinition.of(Items.field_151102_aT);
        ItemDefinition feather = ItemDefinition.of(Items.field_151008_G);
        OreDictDefinition cobblestone = OreDictDefinition.of("cobblestone");
        ItemDefinition puffer = ItemDefinition.of(Items.field_151115_aP, 3);
        OreDictDefinition plankWood = OreDictDefinition.of("plankWood");
        OreDictDefinition ingotGold = OreDictDefinition.of("ingotGold");
        OreDictDefinition ingotIron = OreDictDefinition.of("ingotIron");
        OreDictDefinition blockGlass = OreDictDefinition.of("blockGlass");
        ItemDefinition blockRedWool = ItemDefinition.of(Blocks.field_150325_L, 14);
        ItemDefinition blockPinkWool = ItemDefinition.of(Blocks.field_150325_L, 6);
        ItemDefinition blockGrayWool = ItemDefinition.of(Blocks.field_150325_L, 8);
        ItemDefinition blockYellowWool = ItemDefinition.of(Blocks.field_150325_L, 4);
        this.addRecipe(new ResourceLocation("touhou_little_maid", "spawn_maid"), new SpawnMaidRecipe(0.5f, OreDictDefinition.of("gemDiamond"), blockLapis, blockGold, blockRedstone, blockIron, blockCoal));
        this.addRecipe(new ResourceLocation("touhou_little_maid", "reborn_maid"), new ReviveMaidAltarRecipe(0.3f, ItemDefinition.of(MaidBlocks.GARAGE_KIT, Short.MAX_VALUE), blockLapis, blockGold, blockRedstone, blockIron, blockCoal));
        this.addRecipe(new ResourceLocation("touhou_little_maid", "spawn_light_bolt"), new AltarRecipe(new ResourceLocation("lightning_bolt"), 0.2f, ItemStack.field_190927_a, gunpowder, gunpowder, gunpowder, blazePowder, blazePowder, blazePowder));
        this.addItemCraftRecipe(new ResourceLocation("touhou_little_maid", "craft_album"), 0.1f, new ItemStack(MaidItems.ALBUM), paper, paper, paper, paper, paper, ItemDefinition.of(Items.field_151122_aG));
        this.addItemCraftRecipe(new ResourceLocation("touhou_little_maid", "craft_compass"), 0.1f, new ItemStack(MaidItems.KAPPA_COMPASS), obsidian, obsidian, obsidian, OreDictDefinition.of("dyeBlue"), redstone, redstone);
        this.addItemCraftRecipe(new ResourceLocation("touhou_little_maid", "craft_gohei"), 0.15f, ((ItemHakureiGohei)MaidItems.HAKUREI_GOHEI).getDefaultItemStack(), stick, stick, stick, paper, paper);
        this.addItemCraftRecipe(new ResourceLocation("touhou_little_maid", "craft_camera"), 0.1f, new ItemStack(MaidItems.CAMERA), quartzBlock, quartzBlock, quartzBlock, quartzBlock, obsidian, obsidian);
        this.addItemCraftRecipe(new ResourceLocation("touhou_little_maid", "craft_elixir"), 0.3f, new ItemStack(MaidItems.ULTRAMARINE_ORB_ELIXIR), OreDictDefinition.of("blockEmerald"), OreDictDefinition.of("enderpearl"), dyeCyan, dyeCyan, dyeCyan, dyeCyan);
        this.addItemCraftRecipe(new ResourceLocation("touhou_little_maid", "craft_explosion_protect_bauble"), 0.2f, new ItemStack(MaidItems.EXPLOSION_PROTECT_BAUBLE), ItemDefinition.of(Blocks.field_189878_dg), dyeOrange, obsidian, obsidian, obsidian, obsidian);
        this.addItemCraftRecipe(new ResourceLocation("touhou_little_maid", "craft_fire_protect_bauble"), 0.2f, new ItemStack(MaidItems.FIRE_PROTECT_BAUBLE), ItemDefinition.of(Blocks.field_189878_dg), dyeRed, blazePowder, blazePowder, blazePowder, blazePowder);
        this.addItemCraftRecipe(new ResourceLocation("touhou_little_maid", "craft_projectile_protect_bauble"), 0.2f, new ItemStack(MaidItems.PROJECTILE_PROTECT_BAUBLE), ItemDefinition.of(Blocks.field_189878_dg), dyeBlue, shield, shield, shield, shield);
        this.addItemCraftRecipe(new ResourceLocation("touhou_little_maid", "craft_magic_protect_bauble"), 0.2f, new ItemStack(MaidItems.MAGIC_PROTECT_BAUBLE), ItemDefinition.of(Blocks.field_189878_dg), dyeCyan, sugar, sugar, sugar, sugar);
        this.addItemCraftRecipe(new ResourceLocation("touhou_little_maid", "craft_fall_protect_bauble"), 0.2f, new ItemStack(MaidItems.FALL_PROTECT_BAUBLE), ItemDefinition.of(Blocks.field_189878_dg), dyeYellow, feather, feather, feather, feather);
        this.addItemCraftRecipe(new ResourceLocation("touhou_little_maid", "craft_drown_protect_bauble"), 0.2f, new ItemStack(MaidItems.DROWN_PROTECT_BAUBLE), ItemDefinition.of(Blocks.field_189878_dg), dyeLime, puffer, puffer, puffer, puffer);
        this.addItemCraftRecipe(new ResourceLocation("touhou_little_maid", "craft_tombstone_bauble"), 0.3f, new ItemStack(MaidItems.TOMBSTONE_BAUBLE), ItemDefinition.of((Block)Blocks.field_150486_ae), ItemDefinition.of((Block)Blocks.field_150328_O), OreDictDefinition.of("enderpearl"), cobblestone, cobblestone, cobblestone);
        this.addItemCraftRecipe(new ResourceLocation("touhou_little_maid", "craft_maid_beacon"), 0.3f, new ItemStack(MaidItems.MAID_BEACON), plankWood, dyeRed, plankWood, obsidian, OreDictDefinition.of("gemDiamond"), obsidian);
        this.addItemCraftRecipe(new ResourceLocation("touhou_little_maid", "craft_gashapon_machines"), 0.3f, new ItemStack(MaidBlocks.GASHAPON_MACHINES), blockGlass, blockGlass, ingotGold, ingotGold, ingotGold, ingotGold);
        this.addItemCraftRecipe(new ResourceLocation("touhou_little_maid", "craft_maid_backpack_small"), 0.1f, new ItemStack(MaidItems.MAID_BACKPACK, 1, 1), blockRedWool, blockRedWool, blockRedWool, blockRedWool, ingotIron, blockRedWool);
        this.addItemCraftRecipe(new ResourceLocation("touhou_little_maid", "craft_maid_backpack_middle"), 0.2f, new ItemStack(MaidItems.MAID_BACKPACK, 1, 2), blockPinkWool, blockPinkWool, blockPinkWool, blockPinkWool, ingotGold, blockPinkWool);
        this.addItemCraftRecipe(new ResourceLocation("touhou_little_maid", "craft_maid_backpack_big"), 0.3f, new ItemStack(MaidItems.MAID_BACKPACK, 1, 3), blockGrayWool, blockGrayWool, blockGrayWool, ItemDefinition.of(Blocks.field_150325_L, 5), OreDictDefinition.of("gemDiamond"), ItemDefinition.of(Blocks.field_150325_L, 4));
        this.addItemCraftRecipe(new ResourceLocation("touhou_little_maid", "craft_suitcase"), 0.2f, new ItemStack(MaidItems.SUITCASE), blockYellowWool, blockYellowWool, blockYellowWool, blockYellowWool, ingotGold, blockYellowWool);
    }

    public static AltarRecipesManager instance() {
        return CommonProxy.ALTAR_RECIPES_MANAGER;
    }

    @Nullable
    public AltarRecipe getMatchRecipe(List<ItemStack> inputStacks) {
        for (AltarRecipe recipe : this.ALTAR_RECIPES_MAP.values()) {
            if (!recipe.matches(inputStacks)) continue;
            return recipe;
        }
        return null;
    }

    public void addRecipe(ResourceLocation id, AltarRecipe altarRecipe) {
        this.ALTAR_RECIPES_MAP.put(id, altarRecipe);
    }

    public void addItemCraftRecipe(ResourceLocation id, float powerCost, ItemStack output, ProcessingInput ... inputs) {
        this.addRecipe(id, new AltarRecipe(AltarRecipe.ENTITY_ITEM_ID, powerCost, output, inputs));
    }

    public void removeRecipe(ResourceLocation id) {
        this.ALTAR_RECIPES_MAP.remove(id);
    }

    public Map<ResourceLocation, AltarRecipe> getAltarRecipesMap() {
        return this.ALTAR_RECIPES_MAP;
    }
}

