/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.crafting;

import com.github.tartaricacid.touhoulittlemaid.api.util.ProcessingInput;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.RecipeMatcher;

public class AltarRecipe {
    static final ResourceLocation ENTITY_ITEM_ID = new ResourceLocation("item");
    private static final int RECIPES_SIZE = 6;
    private ResourceLocation entityId;
    private float powerCost;
    private ItemStack output = ItemStack.field_190927_a;
    private List<ProcessingInput> inputs;

    public AltarRecipe(ResourceLocation entityId, float powerCost, ItemStack output, ProcessingInput ... inputs) {
        this.entityId = entityId;
        this.powerCost = powerCost;
        if (entityId.equals((Object)ENTITY_ITEM_ID) && !output.func_190926_b()) {
            this.output = output;
        }
        if (inputs.length == 0 || inputs.length > 6) {
            throw new IllegalAccessError();
        }
        this.inputs = Lists.newArrayList((Object[])inputs);
    }

    public Entity getOutputEntity(World world, BlockPos pos, List<ItemStack> inputItems) {
        Entity entity;
        if (EntityList.field_191307_a.equals((Object)this.entityId)) {
            entity = new EntityLightningBolt(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), false);
        } else {
            entity = Objects.requireNonNull(EntityList.func_188429_b((ResourceLocation)this.entityId, (World)world));
            entity.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.8, (double)pos.func_177952_p());
            if (this.isItemCraft() && entity instanceof EntityItem) {
                ((EntityItem)entity).func_92058_a(this.output.func_77946_l());
            } else if (entity instanceof EntityLiving) {
                ((EntityLiving)entity).func_180482_a(entity.func_130014_f_().func_175649_E(entity.func_180425_c()), null);
            }
        }
        return entity;
    }

    public float getPowerCost() {
        return this.powerCost;
    }

    public List<ProcessingInput> getRecipe() {
        return Collections.unmodifiableList(this.inputs);
    }

    public boolean isItemCraft() {
        return !this.output.func_190926_b();
    }

    public ItemStack getOutputItemStack() {
        return this.output;
    }

    public boolean matches(List<ItemStack> stacks) {
        return RecipeMatcher.findMatches(stacks, this.inputs) != null;
    }
}

