/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.jei.altar;

import com.github.tartaricacid.touhoulittlemaid.api.util.ProcessingInput;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class AltarRecipeWrapper
implements IRecipeWrapper {
    private static final ResourceLocation ICON = new ResourceLocation("touhou_little_maid", "textures/entity/power_point.png");
    private final List<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
    private final List<ItemStack> outputs;
    private final float powerCost;
    private final String resultLanguageKey;
    private final String recipeId;

    AltarRecipeWrapper(List<ProcessingInput> inputs, List<ItemStack> outputs, float powerCost, String resultLanguageKey, String recipeId) {
        this.outputs = outputs;
        for (ProcessingInput input : inputs) {
            this.inputs.add(input.examples());
        }
        this.powerCost = powerCost;
        this.resultLanguageKey = resultLanguageKey;
        this.recipeId = recipeId;
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.inputs);
        ingredients.setOutput(ItemStack.class, this.outputs);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179139_a((double)0.8, (double)0.8, (double)0.8f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(ICON);
        Gui.func_146110_a((int)78, (int)59, (float)32.0f, (float)0.0f, (int)16, (int)16, (float)64.0f, (float)64.0f);
        GlStateManager.func_179121_F();
        FontRenderer fontRenderer = minecraft.field_71466_p;
        String result = I18n.func_135052_a((String)"jei.touhou_little_maid.altar_craft.result", (Object[])new Object[]{I18n.func_135052_a((String)this.resultLanguageKey, (Object[])new Object[0])});
        fontRenderer.func_78276_b(String.format("\u00d7%.2f", Float.valueOf(this.powerCost)), 76, 49, Color.gray.getRGB());
        fontRenderer.func_78276_b(result, (recipeWidth - fontRenderer.func_78256_a(result)) / 2, 85, Color.gray.getRGB());
        fontRenderer.func_78276_b(this.recipeId, (recipeWidth - fontRenderer.func_78256_a(this.recipeId)) / 2, 96, Color.gray.getRGB());
    }
}

