/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.jei.altar;

import com.github.tartaricacid.touhoulittlemaid.compat.jei.altar.AltarRecipeWrapper;
import com.github.tartaricacid.touhoulittlemaid.crafting.AltarRecipe;
import com.github.tartaricacid.touhoulittlemaid.crafting.AltarRecipesManager;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public final class AltarRecipeMaker {
    private AltarRecipeMaker() {
    }

    public static List<AltarRecipeWrapper> getAltarRecipes() {
        Map<ResourceLocation, AltarRecipe> altarRecipesMap = AltarRecipesManager.instance().getAltarRecipesMap();
        ArrayList recipes = Lists.newArrayList();
        for (ResourceLocation id : altarRecipesMap.keySet()) {
            AltarRecipe altarRecipe = altarRecipesMap.get(id);
            String key = altarRecipe.isItemCraft() ? String.format("jei.%s.altar_craft.%s.result", id.func_110624_b().toLowerCase(Locale.US), "item_craft") : String.format("jei.%s.altar_craft.%s.result", id.func_110624_b().toLowerCase(Locale.US), id.func_110623_a().toLowerCase(Locale.US));
            ItemStack output = altarRecipe.getOutputItemStack();
            recipes.add(new AltarRecipeWrapper(altarRecipe.getRecipe(), Collections.singletonList(output), altarRecipe.getPowerCost(), key, id.toString()));
        }
        return recipes;
    }
}

