/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.command;

import com.github.tartaricacid.touhoulittlemaid.capability.CapabilityOwnerMaidNumHandler;
import com.github.tartaricacid.touhoulittlemaid.capability.CapabilityPowerHandler;
import com.github.tartaricacid.touhoulittlemaid.capability.OwnerMaidNumHandler;
import com.github.tartaricacid.touhoulittlemaid.capability.PowerHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class MainCommand
extends CommandBase {
    @Nonnull
    public String func_71517_b() {
        return "touhou_little_maid";
    }

    @Nonnull
    public List<String> func_71514_a() {
        ArrayList<String> aliases = new ArrayList<String>();
        aliases.add("tlm");
        aliases.add("touhou");
        aliases.add("th");
        return aliases;
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        if (args.length >= 3) {
            if ("power".equals(args[0])) {
                this.commandPower(server, sender, args);
                return;
            }
            if ("maid_num".equals(args[0])) {
                this.commandMaidNum(server, sender, args);
                return;
            }
        }
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.touhou_little_maid.main.usage", new Object[0]));
    }

    @Nonnull
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        ArrayList<String> command = new ArrayList<String>();
        switch (args.length) {
            case 1: {
                command.add("power");
                command.add("maid_num");
                command.add("draw");
                break;
            }
            case 2: {
                command.add("get");
                command.add("set");
                command.add("add");
                command.add("min");
                break;
            }
            case 3: {
                command.addAll(Arrays.asList(server.func_71213_z()));
                break;
            }
        }
        return MainCommand.func_175762_a((String[])args, command);
    }

    private void commandPower(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        float num;
        EntityPlayerMP player = MainCommand.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[2]);
        PowerHandler power = (PowerHandler)player.getCapability(CapabilityPowerHandler.POWER_CAP, null);
        float f = num = args.length >= 4 ? (float)MainCommand.func_175765_c((String)args[3]) : 1.0f;
        if (power == null) {
            return;
        }
        switch (args[1]) {
            case "get": {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("commands.touhou_little_maid.main.power.info", new Object[]{Float.valueOf(power.get())}));
                break;
            }
            case "set": {
                power.set(num);
                player.func_145747_a((ITextComponent)new TextComponentTranslation("commands.touhou_little_maid.main.power.info", new Object[]{Float.valueOf(power.get())}));
                break;
            }
            case "add": {
                power.add(num);
                player.func_145747_a((ITextComponent)new TextComponentTranslation("commands.touhou_little_maid.main.power.info", new Object[]{Float.valueOf(power.get())}));
                break;
            }
            case "min": {
                power.min(num);
                player.func_145747_a((ITextComponent)new TextComponentTranslation("commands.touhou_little_maid.main.power.info", new Object[]{Float.valueOf(power.get())}));
                break;
            }
            default: {
                player.func_145747_a((ITextComponent)new TextComponentTranslation(this.func_71518_a(sender), new Object[0]));
            }
        }
    }

    private void commandMaidNum(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        int num;
        EntityPlayerMP player = MainCommand.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[2]);
        OwnerMaidNumHandler numHandler = (OwnerMaidNumHandler)player.getCapability(CapabilityOwnerMaidNumHandler.OWNER_MAID_NUM_CAP, null);
        int n = num = args.length >= 4 ? MainCommand.func_175755_a((String)args[3]) : 1;
        if (numHandler == null) {
            return;
        }
        switch (args[1]) {
            case "get": {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("commands.touhou_little_maid.main.maid_num.info", new Object[]{numHandler.get()}));
                break;
            }
            case "set": {
                numHandler.set(num);
                player.func_145747_a((ITextComponent)new TextComponentTranslation("commands.touhou_little_maid.main.maid_num.info", new Object[]{numHandler.get()}));
                break;
            }
            case "add": {
                numHandler.add(num);
                player.func_145747_a((ITextComponent)new TextComponentTranslation("commands.touhou_little_maid.main.maid_num.info", new Object[]{numHandler.get()}));
                break;
            }
            case "min": {
                numHandler.min(num);
                player.func_145747_a((ITextComponent)new TextComponentTranslation("commands.touhou_little_maid.main.maid_num.info", new Object[]{numHandler.get()}));
                break;
            }
            default: {
                player.func_145747_a((ITextComponent)new TextComponentTranslation(this.func_71518_a(sender), new Object[0]));
            }
        }
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return "commands.touhou_little_maid.main.usage";
    }
}

