/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.resources.pojo;

import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.ResourceLocation;

public class ModelItem {
    private String name;
    private List<String> description;
    private ResourceLocation model;
    private ResourceLocation texture;
    @SerializedName(value="model_id")
    private ResourceLocation modelId;
    @SerializedName(value="render_item_scale")
    private float renderItemScale = 1.0f;
    @Deprecated
    private int format = -1;
    @SerializedName(value="mounted_height")
    private float mountedYOffset;
    @SerializedName(value="tameable_can_ride")
    private boolean tameableCanRide = true;
    @SerializedName(value="no_gravity")
    private boolean noGravity = false;

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getDescription() {
        return this.description;
    }

    public ResourceLocation getModelId() {
        return this.modelId;
    }

    public ResourceLocation getModel() {
        return this.model;
    }

    public float getMountedYOffset() {
        return this.mountedYOffset;
    }

    public boolean isTameableCanRide() {
        return this.tameableCanRide;
    }

    public float getRenderItemScale() {
        return this.renderItemScale;
    }

    public boolean isNoGravity() {
        return this.noGravity;
    }

    @Deprecated
    public int getFormat() {
        return this.format;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public ModelItem decorate(int format) {
        if (this.format < 0) {
            this.format = format;
        }
        if (this.description == null) {
            this.description = Collections.EMPTY_LIST;
        }
        if (this.modelId == null) {
            throw new JsonSyntaxException("Expected \"model_id\" in model");
        }
        if (this.model == null) {
            this.model = new ResourceLocation(this.modelId.func_110624_b(), "models/entity/" + this.modelId.func_110623_a() + ".json");
        }
        if (this.texture == null) {
            this.texture = new ResourceLocation(this.modelId.func_110624_b(), "textures/entity/" + this.modelId.func_110623_a() + ".png");
        }
        if (this.name == null) {
            this.name = String.format("{model.%s.%s.name}", this.modelId.func_110624_b(), this.modelId.func_110623_a());
        }
        this.mountedYOffset = (this.mountedYOffset - 3.0f) * 0.0625f;
        return this;
    }
}

