/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.resources;

import com.github.tartaricacid.touhoulittlemaid.client.model.EntityModelJson;
import com.github.tartaricacid.touhoulittlemaid.client.resources.pojo.CustomModelPackPOJO;
import com.github.tartaricacid.touhoulittlemaid.client.resources.pojo.ModelItem;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class CustomModelResources {
    private String jsonFileName;
    private List<CustomModelPackPOJO> packList;
    private HashMap<String, EntityModelJson> idModelMap;
    private HashMap<String, ModelItem> idInfoMap;

    public CustomModelResources(String jsonFileName, List<CustomModelPackPOJO> packList, HashMap<String, EntityModelJson> idToModel, HashMap<String, ModelItem> idToInfo) {
        this.jsonFileName = jsonFileName;
        this.packList = packList;
        this.idModelMap = idToModel;
        this.idInfoMap = idToInfo;
    }

    public void clearAll() {
        this.packList.clear();
        this.idModelMap.clear();
        this.idInfoMap.clear();
    }

    public String getJsonFileName() {
        return this.jsonFileName;
    }

    public List<CustomModelPackPOJO> getPackList() {
        return this.packList;
    }

    public Set<String> getModelIdSet() {
        return this.idInfoMap.keySet();
    }

    public void addPack(CustomModelPackPOJO pack) {
        this.packList.add(pack);
    }

    public void putModel(String modelId, EntityModelJson modelJson) {
        this.idModelMap.put(modelId, modelJson);
    }

    public void putInfo(String modelId, ModelItem modelItem) {
        this.idInfoMap.put(modelId, modelItem);
    }

    public Optional<EntityModelJson> getModel(String modelId) {
        return Optional.ofNullable(this.idModelMap.get(modelId));
    }

    public float getModelRenderItemScale(String modelId) {
        if (this.idInfoMap.containsKey(modelId)) {
            return this.idInfoMap.get(modelId).getRenderItemScale();
        }
        return 1.0f;
    }

    public float getModelMountedYOffset(String modelId) {
        if (this.idInfoMap.containsKey(modelId)) {
            return this.idInfoMap.get(modelId).getMountedYOffset();
        }
        return 0.0f;
    }

    public boolean getModelTameableCanRide(String modelId) {
        if (this.idInfoMap.containsKey(modelId)) {
            return this.idInfoMap.get(modelId).isTameableCanRide();
        }
        return true;
    }

    public boolean getModelNoGravity(String modelId) {
        if (this.idInfoMap.containsKey(modelId)) {
            return this.idInfoMap.get(modelId).isNoGravity();
        }
        return false;
    }

    public Optional<ModelItem> getInfo(String modelId) {
        return Optional.ofNullable(this.idInfoMap.get(modelId));
    }
}

