/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.resources;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.model.EntityModelJson;
import com.github.tartaricacid.touhoulittlemaid.client.model.pojo.CustomModelPOJO;
import com.github.tartaricacid.touhoulittlemaid.client.resources.CustomModelResources;
import com.github.tartaricacid.touhoulittlemaid.client.resources.pojo.CustomModelPackPOJO;
import com.github.tartaricacid.touhoulittlemaid.client.resources.pojo.ModelItem;
import com.github.tartaricacid.touhoulittlemaid.proxy.CommonProxy;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

@SideOnly(value=Side.CLIENT)
public final class CustomModelLoader {
    private static final Logger LOGGER = TouhouLittleMaid.LOGGER;
    private static final Marker MARKER = MarkerManager.getMarker((String)"ModelLoader");
    private static final String OLD_BEDROCK_VERSION = "1.10.0";
    private static IResourceManager manager = Minecraft.func_71410_x().func_110442_L();

    public static void reloadModelPack(CustomModelResources resources) {
        resources.clearAll();
        CustomModelLoader.loadModelPack(resources);
    }

    private static void loadModelPack(CustomModelResources resources) {
        LOGGER.info(MARKER, "Touhou little maid mod's model is loading...");
        CustomModelLoader.loadModelPackMain(resources.getJsonFileName(), pojo -> {
            CustomModelLoader.loadModelList(pojo.getModelList(), (modelItem, modelJson) -> {
                String id = modelItem.getModelId().toString();
                resources.putModel(id, (EntityModelJson)((Object)((Object)modelJson)));
                resources.putInfo(id, (ModelItem)modelItem);
            });
            resources.addPack((CustomModelPackPOJO)pojo);
        });
        LOGGER.info(MARKER, "Touhou little maid mod's model is loaded");
    }

    private static void loadModelPackMain(String pathIn, Consumer<CustomModelPackPOJO> consumer) {
        for (String domain : manager.func_135055_a()) {
            try {
                ResourceLocation res = new ResourceLocation(domain, pathIn);
                InputStream inputStream = manager.func_110536_a(res).func_110527_b();
                CustomModelPackPOJO pojo = CommonProxy.readModelPack(inputStream);
                IOUtils.closeQuietly((InputStream)inputStream);
                consumer.accept(pojo);
            }
            catch (IOException res) {
            }
            catch (JsonSyntaxException e) {
                LOGGER.warn(MARKER, "Fail to parse model pack in domain {}", (Object)domain);
                e.printStackTrace();
            }
        }
    }

    private static void loadModelList(List<ModelItem> modelList, BiConsumer<ModelItem, EntityModelJson> biConsumer) throws JsonSyntaxException {
        for (ModelItem modelItem : modelList) {
            EntityModelJson modelJson = CustomModelLoader.loadModel(modelItem.getModel(), modelItem.getFormat());
            if (modelJson == null) continue;
            biConsumer.accept(modelItem, modelJson);
            LOGGER.info(MARKER, "Loaded model: {}", (Object)modelItem.getModel());
        }
    }

    @Nullable
    private static EntityModelJson loadModel(ResourceLocation modelLocation, int format) {
        try {
            InputStream input = manager.func_110536_a(modelLocation).func_110527_b();
            CustomModelPOJO pojo = (CustomModelPOJO)CommonProxy.GSON.fromJson((Reader)new InputStreamReader(input, StandardCharsets.UTF_8), CustomModelPOJO.class);
            IOUtils.closeQuietly((InputStream)input);
            if (!pojo.getFormatVersion().equals(OLD_BEDROCK_VERSION)) {
                LOGGER.warn(MARKER, "{} model version is not 1.10.0", (Object)modelLocation);
                return null;
            }
            if (pojo.getGeometryModel() != null) {
                return new EntityModelJson(pojo, format);
            }
            LOGGER.warn(MARKER, "{} model file don't have model field", (Object)modelLocation);
        }
        catch (IOException ioe) {
            LOGGER.warn(MARKER, "Failed to load model: {}", (Object)modelLocation);
        }
        return null;
    }
}

