/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.texture;

import com.github.tartaricacid.touhoulittlemaid.client.renderer.texture.HataTexture;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class HataTextureManager {
    private static final Map<String, ITextureObject> MAP_TEXTURE_OBJECTS = Maps.newHashMap();
    private static final Logger LOGGER = LogManager.getLogger((String)"HataTextureManager");
    private static IResourceManager RESOURCE_MANAGER;

    public HataTextureManager(IResourceManager resourceManager) {
        RESOURCE_MANAGER = resourceManager;
    }

    public void bindTexture(String texturePath) {
        GlStateManager.func_179144_i((int)this.loadTexture(texturePath));
    }

    public int loadTexture(String texturePath) {
        Object itextureobject = MAP_TEXTURE_OBJECTS.get(texturePath);
        if (itextureobject == null) {
            itextureobject = new HataTexture(texturePath);
            this.loadTexture(texturePath, (ITextureObject)itextureobject);
        }
        return itextureobject.func_110552_b();
    }

    private void loadTexture(String texturePath, ITextureObject textureObj) {
        try {
            textureObj.func_110551_a(RESOURCE_MANAGER);
        }
        catch (IOException ioexception) {
            LOGGER.warn("Failed to load texture: {}", (Object)texturePath, (Object)ioexception);
            textureObj = TextureUtil.field_111001_a;
            MAP_TEXTURE_OBJECTS.put(texturePath, textureObj);
        }
        MAP_TEXTURE_OBJECTS.put(texturePath, textureObj);
    }

    public Map<String, ITextureObject> getMapTexture() {
        return MAP_TEXTURE_OBJECTS;
    }

    public ITextureObject getTexture(String texturePath) {
        return MAP_TEXTURE_OBJECTS.get(texturePath);
    }

    public void deleteTexture(String texturePath) {
        ITextureObject itextureobject = this.getTexture(texturePath);
        if (itextureobject != null) {
            MAP_TEXTURE_OBJECTS.remove(texturePath);
            TextureUtil.func_147942_a((int)itextureobject.func_110552_b());
        }
    }

    public void clear() {
        MAP_TEXTURE_OBJECTS.clear();
    }
}

