/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layers.LayerHataSasimono;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layers.LayerMaidArrow;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layers.LayerMaidBackpack;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layers.LayerMaidCustomHead;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layers.LayerMaidDebugBroom;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layers.LayerMaidDebugFloor;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layers.LayerMaidHeldItem;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import com.github.tartaricacid.touhoulittlemaid.proxy.ClientProxy;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class EntityMaidRender
extends RenderLiving<EntityMaid> {
    public static final Factory FACTORY = new Factory();
    private static final String DEFAULT_MODEL_ID = "touhou_little_maid:hakurei_reimu";
    private static final ResourceLocation DEFAULT_MODEL_TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/hakurei_reimu.png");
    private ResourceLocation modelRes = DEFAULT_MODEL_TEXTURE;

    private EntityMaidRender(RenderManager renderManager, ModelBase modelBase, float shadowSize) {
        super(renderManager, modelBase, shadowSize);
        this.func_177094_a(new LayerMaidArrow((RenderLivingBase<?>)this));
        this.func_177094_a(new LayerMaidHeldItem(this));
        this.func_177094_a(new LayerMaidDebugFloor());
        this.func_177094_a(new LayerMaidDebugBroom());
        this.func_177094_a(new LayerHataSasimono());
        this.func_177094_a(new LayerMaidCustomHead(this));
        this.func_177094_a(new LayerMaidBackpack(this));
    }

    public void doRender(@Nonnull EntityMaid entity, double x, double y, double z, float entityYaw, float partialTicks) {
        this.field_77045_g = ClientProxy.MAID_MODEL.getModel(DEFAULT_MODEL_ID).orElseThrow(NullPointerException::new);
        ClientProxy.MAID_MODEL.getModel(entity.getModelId()).ifPresent(model -> {
            this.field_77045_g = model;
        });
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    protected boolean canRenderName(EntityMaid entity) {
        return Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77973_b() == MaidItems.KAPPA_COMPASS && entity.func_184753_b() != null && entity.func_184753_b().equals(Minecraft.func_71410_x().field_71439_g.func_110124_au());
    }

    protected void renderEntityName(@Nonnull EntityMaid entityIn, double x, double y, double z, String name, double distanceSq) {
        BlockPos pos = entityIn.getHomePos();
        String str = pos.equals((Object)BlockPos.field_177992_a) ? I18n.func_135052_a((String)"info.touhou_little_maid.maid.unset_pos", (Object[])new Object[0]) : I18n.func_135052_a((String)"info.touhou_little_maid.maid.set_pos", (Object[])new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
        super.func_188296_a((Entity)entityIn, x, y, z, str, 16.0);
    }

    @Nullable
    protected ResourceLocation getEntityTexture(@Nonnull EntityMaid entity) {
        this.modelRes = DEFAULT_MODEL_TEXTURE;
        ClientProxy.MAID_MODEL.getInfo(entity.getModelId()).ifPresent(modelItem -> {
            this.modelRes = modelItem.getTexture();
        });
        return this.modelRes;
    }

    public static class Factory
    implements IRenderFactory<EntityMaid> {
        public Render<? super EntityMaid> createRenderFor(RenderManager manager) {
            return new EntityMaidRender(manager, ClientProxy.MAID_MODEL.getModel(EntityMaidRender.DEFAULT_MODEL_ID).orElseThrow(NullPointerException::new), 0.5f);
        }
    }
}

