/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.config.GeneralConfig;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class EntityChangeXPRender
extends Render<EntityXPOrb> {
    public static final Factory FACTORY = new Factory();
    private static final ResourceLocation EXPERIENCE_ORB_TEXTURES = new ResourceLocation("textures/entity/experience_orb.png");
    private static final ResourceLocation POINT_ITEM_TEXTURES = new ResourceLocation("touhou_little_maid", "textures/entity/point_item.png");

    private EntityChangeXPRender(RenderManager renderManager) {
        super(renderManager);
        this.field_76989_e = 0.15f;
        this.field_76987_f = 0.75f;
    }

    public void doRender(@Nonnull EntityXPOrb entity, double x, double y, double z, float entityYaw, float partialTicks) {
        if (!this.field_188301_f) {
            if (GeneralConfig.VANILLA_CONFIG.changeXPTexture) {
                this.drawEntityPoint(entity, x, y, z, this.field_76990_c, e -> this.func_180548_c((Entity)((EntityXPOrb)e)));
            } else {
                this.drawEntityXP(entity, x, y, z, partialTicks, this.field_76990_c, e -> this.func_180548_c((Entity)((EntityXPOrb)e)));
            }
            super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
        }
    }

    @Nullable
    protected ResourceLocation getEntityTexture(@Nonnull EntityXPOrb entity) {
        if (GeneralConfig.VANILLA_CONFIG.changeXPTexture) {
            return POINT_ITEM_TEXTURES;
        }
        return EXPERIENCE_ORB_TEXTURES;
    }

    private void drawEntityXP(EntityXPOrb entity, double x, double y, double z, float partialTicks, RenderManager renderManager, Consumer<Entity> textureBindFunc) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
        textureBindFunc.accept((Entity)entity);
        RenderHelper.func_74519_b();
        int textureIndex = entity.func_70528_g();
        double texturePos1 = (double)(textureIndex % 4 * 16) / 64.0;
        double texturePos2 = (double)(textureIndex % 4 * 16 + 16) / 64.0;
        double texturePos3 = (double)(textureIndex / 4 * 16) / 64.0;
        double texturePos4 = (double)(textureIndex / 4 * 16 + 16) / 64.0;
        int brightness = entity.func_70070_b();
        int lightmapX = brightness % 65536;
        int lightmapY = brightness / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightmapX, (float)lightmapY);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float tmpValue = ((float)entity.field_70533_a + partialTicks) / 2.0f;
        lightmapY = (int)((MathHelper.func_76126_a((float)(tmpValue + 0.0f)) + 1.0f) * 0.5f * 255.0f);
        int j1 = (int)((MathHelper.func_76126_a((float)(tmpValue + 4.1887903f)) + 1.0f) * 0.1f * 255.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.1f, (float)0.0f);
        GlStateManager.func_179114_b((float)(180.0f - renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)(renderManager.field_78733_k.field_74320_O == 2 ? -1 : 1) * -renderManager.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)0.3f, (float)0.3f, (float)0.3f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181712_l);
        bufferbuilder.func_181662_b(-0.5, -0.25, 0.0).func_187315_a(texturePos1, texturePos4).func_181669_b(lightmapY, 255, j1, 128).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(0.5, -0.25, 0.0).func_187315_a(texturePos2, texturePos4).func_181669_b(lightmapY, 255, j1, 128).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(0.5, 0.75, 0.0).func_187315_a(texturePos2, texturePos3).func_181669_b(lightmapY, 255, j1, 128).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(-0.5, 0.75, 0.0).func_187315_a(texturePos1, texturePos3).func_181669_b(lightmapY, 255, j1, 128).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
    }

    private void drawEntityPoint(EntityXPOrb entity, double x, double y, double z, RenderManager renderManager, Consumer<Entity> textureBindFunc) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
        textureBindFunc.accept((Entity)entity);
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)170.0f, (float)170.0f);
        int textureIndex = entity.func_70528_g();
        double texturePos1 = (double)(textureIndex % 4 * 16) / 64.0;
        double texturePos2 = (double)(textureIndex % 4 * 16 + 16) / 64.0;
        double texturePos3 = (float)(textureIndex / 4 * 16) / 64.0f;
        double texturePos4 = (double)(textureIndex / 4 * 16 + 16) / 64.0;
        GlStateManager.func_179109_b((float)0.0f, (float)0.1f, (float)0.0f);
        GlStateManager.func_179114_b((float)(180.0f - renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)(renderManager.field_78733_k.field_74320_O == 2 ? -1 : 1) * -renderManager.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)0.3f, (float)0.3f, (float)0.3f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(-1.0, -0.25, 0.0).func_187315_a(texturePos1, texturePos4).func_181675_d();
        bufferbuilder.func_181662_b(1.0, -0.25, 0.0).func_187315_a(texturePos2, texturePos4).func_181675_d();
        bufferbuilder.func_181662_b(1.0, 1.75, 0.0).func_187315_a(texturePos2, texturePos3).func_181675_d();
        bufferbuilder.func_181662_b(-1.0, 1.75, 0.0).func_187315_a(texturePos1, texturePos3).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
    }

    public static class Factory
    implements IRenderFactory<EntityXPOrb> {
        public Render<? super EntityXPOrb> createRenderFor(RenderManager manager) {
            return new EntityChangeXPRender(manager);
        }
    }
}

