/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.client.model.EntityModelJson;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layers.LayerChairDebugCharacter;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layers.LayerChairDebugFloor;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import com.github.tartaricacid.touhoulittlemaid.proxy.ClientProxy;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class EntityChairRender
extends RenderLivingBase<EntityChair> {
    public static final Factory FACTORY = new Factory();
    private static final String DEFAULT_CHAIR_ID = "touhou_little_maid:cushion";
    private static final ResourceLocation DEFAULT_CHAIR_TEXTURE = new ResourceLocation("touhou_little_maid:textures/entity/cushion.png");
    private ResourceLocation modelRes = DEFAULT_CHAIR_TEXTURE;

    private EntityChairRender(RenderManager renderManager, EntityModelJson mainModel) {
        super(renderManager, (ModelBase)mainModel, 0.0f);
        this.func_177094_a(new LayerChairDebugFloor());
        this.func_177094_a(new LayerChairDebugCharacter());
    }

    public void doRender(@Nonnull EntityChair chair, double x, double y, double z, float entityYaw, float partialTicks) {
        this.field_77045_g = ClientProxy.CHAIR_MODEL.getModel(DEFAULT_CHAIR_ID).orElseThrow(NullPointerException::new);
        ClientProxy.CHAIR_MODEL.getModel(chair.getModelId()).ifPresent(model -> {
            this.field_77045_g = model;
        });
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        super.func_76986_a((EntityLivingBase)chair, x, y, z, entityYaw, partialTicks);
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    @Nullable
    protected ResourceLocation getEntityTexture(@Nonnull EntityChair chair) {
        this.modelRes = DEFAULT_CHAIR_TEXTURE;
        ClientProxy.CHAIR_MODEL.getInfo(chair.getModelId()).ifPresent(modelItem -> {
            this.modelRes = modelItem.getTexture();
        });
        return this.modelRes;
    }

    protected void applyRotations(EntityChair chair, float ageInTicks, float rotationYaw, float partialTicks) {
        GlStateManager.func_179114_b((float)(180.0f - chair.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
    }

    protected boolean canRenderName(EntityChair entity) {
        return entity.func_174833_aM();
    }

    public static class Factory
    implements IRenderFactory<EntityChair> {
        public Render<? super EntityChair> createRenderFor(RenderManager manager) {
            return new EntityChairRender(manager, ClientProxy.CHAIR_MODEL.getModel(EntityChairRender.DEFAULT_CHAIR_ID).orElseThrow(NullPointerException::new));
        }
    }
}

